/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.processors.UpdateResult;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.Files;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BackupProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("BackupProcessor");

    @Override
    public String process(ProcessContext context) throws ProcessException {
        File agentDir = (File)context.get("Agent-Directory");
        if (agentDir == null) {
            return "failed";
        }
        try {
            File backupDir = new File(agentDir, "backup");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = sdf.format(new Date());
            backupDir = new File(backupDir, date);
            int i = 0;
            while (backupDir.exists()) {
                String new_date = date + "_" + i++;
                File old_backupDir = backupDir;
                backupDir = new File(old_backupDir, new_date);
                this.logger.warn("The backup directory {} already exists. changed to {}", old_backupDir.getAbsolutePath(), backupDir.getAbsolutePath());
            }
            backupDir.mkdirs();
            File extensionsDir = new File(agentDir, "extensions");
            if (extensionsDir.exists()) {
                Files.pathCopy(extensionsDir, new File(backupDir, "extensions"));
            }
            File agentFile = new File(agentDir, "tapm-agent-core.jar");
            Files.fileCopy(agentFile, new File(backupDir, "tapm-agent-core.jar"));
            File agentConfigFile = new File(agentDir, "tapm.properties");
            Files.fileCopy(agentConfigFile, new File(backupDir, "tapm.properties"));
        }
        catch (Exception e) {
            context.put("context_update_result", UpdateResult.failed(5, "Error in backup agent path, " + e.getMessage(), e));
            this.logger.error("Backup Tapm agent failed", e);
            return "failed";
        }
        return "next";
    }
}

