/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.ResponseMessageFutureListener;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.util.AgentInfoFactory;
import com.navercorp.pinpoint.rpc.DefaultFuture;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.thrift.dto.TAgentInfo;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.DeserializerFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInfoSender {
    private static final long DEFAULT_AGENT_INFO_REFRESH_INTERVAL_MS = 86400000L;
    private static final long DEFAULT_AGENT_INFO_SEND_INTERVAL_MS = 3000L;
    private static final int DEFAULT_MAX_TRY_COUNT_PER_ATTEMPT = 3;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EnhancedDataSender dataSender;
    private final AgentInfoFactory agentInfoFactory;
    private final long refreshIntervalMs;
    private final long sendIntervalMs;
    private final int maxTryPerAttempt;
    private final Scheduler scheduler;

    private AgentInfoSender(Builder builder) {
        this.dataSender = builder.dataSender;
        this.agentInfoFactory = builder.agentInfoFactory;
        this.refreshIntervalMs = builder.refreshIntervalMs;
        this.sendIntervalMs = builder.sendIntervalMs;
        this.maxTryPerAttempt = builder.maxTryPerAttempt;
        this.scheduler = new Scheduler();
    }

    public void start() {
        this.scheduler.start();
    }

    public void stop() {
        this.scheduler.stop();
        this.logger.info("AgentInfoSender stopped");
    }

    public void refresh() {
        this.scheduler.refresh();
    }

    public static class Builder {
        private final EnhancedDataSender dataSender;
        private final AgentInfoFactory agentInfoFactory;
        private long refreshIntervalMs = 86400000L;
        private long sendIntervalMs = 3000L;
        private int maxTryPerAttempt = 3;

        public Builder(EnhancedDataSender dataSender, AgentInfoFactory agentInfoFactory) {
            if (dataSender == null) {
                throw new NullPointerException("enhancedDataSender must not be null");
            }
            if (agentInfoFactory == null) {
                throw new NullPointerException("agentInfoFactory must not be null");
            }
            this.dataSender = dataSender;
            this.agentInfoFactory = agentInfoFactory;
        }

        public Builder refreshInterval(long refreshIntervalMs) {
            this.refreshIntervalMs = refreshIntervalMs;
            return this;
        }

        public Builder sendInterval(long sendIntervalMs) {
            this.sendIntervalMs = sendIntervalMs;
            return this;
        }

        public Builder maxTryPerAttempt(int maxTryCountPerAttempt) {
            this.maxTryPerAttempt = maxTryCountPerAttempt;
            return this;
        }

        public AgentInfoSender build() {
            if (this.refreshIntervalMs <= 0L) {
                throw new IllegalStateException("agentInfoRefreshIntervalMs must be greater than 0");
            }
            if (this.sendIntervalMs <= 0L) {
                throw new IllegalStateException("agentInfoSendIntervalMs must be greater than 0");
            }
            if (this.maxTryPerAttempt <= 0) {
                throw new IllegalStateException("maxTryPerAttempt must be greater than 0");
            }
            return new AgentInfoSender(this);
        }
    }

    private class AgentInfoSendTask
    extends TimerTask {
        private final SuccessListener taskHandler;
        private final int retryCount;
        private AtomicInteger counter;

        private AgentInfoSendTask(SuccessListener taskHandler) {
            this(taskHandler, 0);
        }

        private AgentInfoSendTask(SuccessListener taskHandler, int retryCount) {
            if (taskHandler == null) {
                throw new NullPointerException("taskHandler must not be null");
            }
            this.taskHandler = taskHandler;
            this.retryCount = retryCount;
            this.counter = new AtomicInteger(0);
        }

        @Override
        public void run() {
            int runCount = this.counter.incrementAndGet();
            if (runCount > this.retryCount) {
                this.cancel();
                return;
            }
            boolean isSuccessful = this.sendAgentInfo();
            if (isSuccessful) {
                AgentInfoSender.this.logger.info("AgentInfo sent.");
                this.cancel();
                this.taskHandler.onSuccess();
            }
        }

        private boolean sendAgentInfo() {
            try {
                TAgentInfo agentInfo = AgentInfoSender.this.agentInfoFactory.createAgentInfo();
                DefaultFuture future = new DefaultFuture();
                AgentInfoSender.this.logger.info("Sending AgentInfo {}", (Object)agentInfo);
                AgentInfoSender.this.dataSender.request(agentInfo, new ResponseMessageFutureListener((DefaultFuture<ResponseMessage>)future));
                if (!future.await()) {
                    AgentInfoSender.this.logger.warn("request timed out while waiting for response.");
                    return false;
                }
                if (!future.isSuccess()) {
                    Throwable t = future.getCause();
                    AgentInfoSender.this.logger.warn("request failed.", t);
                    return false;
                }
                ResponseMessage responseMessage = (ResponseMessage)future.getResult();
                if (responseMessage == null) {
                    AgentInfoSender.this.logger.warn("result not set.");
                    return false;
                }
                return this.getResult(responseMessage);
            }
            catch (Exception e) {
                AgentInfoSender.this.logger.warn("failed to send agent info.", (Throwable)e);
                return false;
            }
        }

        private boolean getResult(ResponseMessage responseMessage) {
            byte[] byteMessage = responseMessage.getMessage();
            Message message = SerializationUtils.deserialize((byte[])byteMessage, (DeserializerFactory)HeaderTBaseDeserializerFactory.DEFAULT_FACTORY, null);
            if (message == null) {
                AgentInfoSender.this.logger.warn("message is null");
                return false;
            }
            TBase tbase = (TBase)message.getData();
            if (!(tbase instanceof TResult)) {
                AgentInfoSender.this.logger.warn("Invalid response : {}", tbase.getClass());
                return false;
            }
            TResult result = (TResult)tbase;
            if (!result.isSuccess()) {
                AgentInfoSender.this.logger.warn("request unsuccessful. Cause : {}", (Object)result.getMessage());
                return false;
            }
            return true;
        }
    }

    private class Scheduler {
        private static final long IMMEDIATE = 0L;
        private final Timer timer = new Timer("Pinpoint-AgentInfoSender-Timer", true);
        private final Object lock = new Object();
        private boolean isRunning = true;

        private Scheduler() {
            AgentInfoSendTask task = new AgentInfoSendTask(SuccessListener.NO_OP);
            task.run();
        }

        public void start() {
            SuccessListener successListener = new SuccessListener(){

                @Override
                public void onSuccess() {
                    Scheduler.this.schedule(this, AgentInfoSender.this.maxTryPerAttempt, AgentInfoSender.this.refreshIntervalMs, AgentInfoSender.this.sendIntervalMs);
                }
            };
            this.schedule(successListener, Integer.MAX_VALUE, 0L, AgentInfoSender.this.sendIntervalMs);
        }

        public void refresh() {
            this.schedule(SuccessListener.NO_OP, AgentInfoSender.this.maxTryPerAttempt, 0L, AgentInfoSender.this.sendIntervalMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedule(SuccessListener successListener, int retryCount, long delay, long period) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning) {
                    AgentInfoSendTask task = new AgentInfoSendTask(successListener, retryCount);
                    this.timer.scheduleAtFixedRate((TimerTask)task, delay, period);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                this.isRunning = false;
                this.timer.cancel();
            }
        }
    }

    private static interface SuccessListener {
        public static final SuccessListener NO_OP = new SuccessListener(){

            @Override
            public void onSuccess() {
            }
        };

        public void onSuccess();
    }
}

