/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus.filter;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MemcachedMethodFilter
implements MethodFilter {
    private static final Object FIND = new Object();
    private static final Map<String, Object> WHITE_LIST_API = MemcachedMethodFilter.createRule();

    private static Map<String, Object> createRule() {
        String[] apiList = new String[]{"add", "append", "asyncCAS", "asyncDecr", "asyncGet", "asyncGetAndTouch", "asyncGetBulk", "asyncGets", "asyncIncr", "cas", "decr", "delete", "get", "getAndTouch", "getBulk", "gets", "incr", "prepend", "replace", "set", "touch"};
        HashMap<String, Object> rule = new HashMap<String, Object>();
        for (String api : apiList) {
            rule.put(api, FIND);
        }
        return rule;
    }

    public boolean accept(InstrumentMethod ctMethod) {
        int modifiers = ctMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers)) {
            return false;
        }
        return WHITE_LIST_API.get(ctMethod.getName()) == FIND;
    }
}

