/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.lettuce.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor;
import com.navercorp.pinpoint.plugin.redis.lettuce.LettuceConstants;
import com.navercorp.pinpoint.plugin.redis.lettuce.StatefulConnectionGetter;
import io.lettuce.core.api.StatefulConnection;

public class LettuceMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public LettuceMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    public void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        String endPoint = this.toEndPoint(target);
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordEndPoint(endPoint != null ? endPoint : "Unknown");
        recorder.recordDestinationId(LettuceConstants.REDIS_LETTUCE.getName());
        recorder.recordServiceType(LettuceConstants.REDIS_LETTUCE);
        recorder.recordException(throwable);
    }

    private String toEndPoint(Object target) {
        if (!(target instanceof StatefulConnectionGetter)) {
            return null;
        }
        StatefulConnection connection = ((StatefulConnectionGetter)target)._$PINPOINT$_getConnection();
        if (!(connection instanceof EndPointAccessor)) {
            return null;
        }
        return ((EndPointAccessor)connection)._$PINPOINT$_getEndPoint();
    }
}

