/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import com.navercorp.pinpoint.profiler.sampler.BasicTraceSampler;
import com.navercorp.pinpoint.profiler.sampler.RateLimitTraceSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSamplerProvider
implements Provider<TraceSampler> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Sampler sampler;
    private final IdGenerator idGenerator;
    private final ProfilerConfig profilerConfig;

    @Inject
    public TraceSamplerProvider(ProfilerConfig profilerConfig, Sampler sampler, IdGenerator idGenerator) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig");
        this.sampler = (Sampler)Assert.requireNonNull((Object)sampler, (String)"sampler");
        this.idGenerator = (IdGenerator)Assert.requireNonNull((Object)idGenerator, (String)"idGenerator");
    }

    public TraceSampler get() {
        this.logger.info("new BasicTraceSampler()");
        Object traceSampler = new BasicTraceSampler(this.idGenerator, this.sampler);
        int samplingNewThroughput = this.profilerConfig.getSamplingNewThroughput();
        int samplingContinueThroughput = this.profilerConfig.getSamplingContinueThroughput();
        if (samplingNewThroughput > 0 || samplingContinueThroughput > 0) {
            traceSampler = new RateLimitTraceSampler(samplingNewThroughput, samplingContinueThroughput, this.idGenerator, (TraceSampler)traceSampler);
            this.logger.info("new RateLimitTraceSampler {}/{}", (Object)samplingNewThroughput, (Object)samplingContinueThroughput);
        }
        return traceSampler;
    }
}

