/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.compress.Context;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessor;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.util.AnnotationValueMapper;
import com.navercorp.pinpoint.thrift.dto.TAnnotation;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringValue;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TBase;

public class SpanThriftMessageConverter
implements MessageConverter<TBase<?, ?>> {
    private final String agentId;
    private final String applicationName;
    private final long agentStartTime;
    private final short applicationServiceType;
    private final TransactionIdEncoder transactionIdEncoder;
    private final SpanPostProcessor<Context> spanPostProcessor;

    public SpanThriftMessageConverter(String applicationName, String agentId, long agentStartTime, short applicationServiceType, TransactionIdEncoder transactionIdEncoder, SpanPostProcessor<Context> spanPostProcessor) {
        this.applicationName = (String)Assert.requireNonNull((Object)applicationName, (String)"applicationName must not be null");
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTime = agentStartTime;
        this.applicationServiceType = applicationServiceType;
        this.transactionIdEncoder = (TransactionIdEncoder)Assert.requireNonNull((Object)transactionIdEncoder, (String)"transactionIdEncoder must not be null");
        this.spanPostProcessor = (SpanPostProcessor)Assert.requireNonNull(spanPostProcessor, (String)"spanPostProcessor must not be null");
    }

    @Override
    public TBase<?, ?> toMessage(Object message) {
        if (message instanceof SpanChunk) {
            SpanChunk spanChunk = (SpanChunk)message;
            TSpanChunk tSpanChunk = this.buildTSpanChunk(spanChunk);
            return tSpanChunk;
        }
        if (message instanceof Span) {
            Span span = (Span)message;
            return this.buildTSpan(span);
        }
        return null;
    }

    @VisibleForTesting
    TSpan buildTSpan(Span span) {
        List<SpanEvent> spanEventList;
        TSpan tSpan = new TSpan();
        tSpan.setApplicationName(this.applicationName);
        tSpan.setAgentId(this.agentId);
        tSpan.setAgentStartTime(this.agentStartTime);
        tSpan.setApplicationServiceType(this.applicationServiceType);
        TraceRoot traceRoot = span.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        ByteBuffer transactionId = this.transactionIdEncoder.encodeTransactionId(traceId);
        tSpan.setTransactionId(transactionId);
        tSpan.setSpanId(traceId.getSpanId());
        tSpan.setParentSpanId(traceId.getParentSpanId());
        tSpan.setStartTime(span.getStartTime());
        tSpan.setElapsed(span.getElapsedTime());
        tSpan.setServiceType(span.getServiceType());
        tSpan.setRemoteAddr(span.getRemoteAddr());
        Shared shared = traceRoot.getShared();
        tSpan.setRpc(shared.getRpcName());
        tSpan.setEndPoint(shared.getEndPoint());
        tSpan.setFlag(traceId.getFlags());
        tSpan.setErr(shared.getErrorCode());
        tSpan.setParentApplicationName(span.getParentApplicationName());
        tSpan.setParentApplicationType(span.getParentApplicationType());
        tSpan.setAcceptorHost(span.getAcceptorHost());
        tSpan.setApiId(span.getApiId());
        IntStringValue exceptionInfo = span.getExceptionInfo();
        if (exceptionInfo != null) {
            TIntStringValue tIntStringValue = this.buildTIntStringValue(exceptionInfo);
            tSpan.setExceptionInfo(tIntStringValue);
        }
        tSpan.setLoggingTransactionInfo(shared.getLoggingInfo());
        List<Annotation> annotations = span.getAnnotations();
        if (CollectionUtils.hasLength(annotations)) {
            List<TAnnotation> tAnnotations = this.buildTAnnotation(annotations);
            tSpan.setAnnotations(tAnnotations);
        }
        if (CollectionUtils.hasLength(spanEventList = span.getSpanEventList())) {
            Context context = this.spanPostProcessor.newContext(span, tSpan);
            List<TSpanEvent> tSpanEvents = this.buildTSpanEventList(spanEventList, context);
            context.finish();
            tSpan.setSpanEventList(tSpanEvents);
        }
        return tSpan;
    }

    private List<TSpanEvent> buildTSpanEventList(List<SpanEvent> spanEventList, Context context) {
        int eventSize = spanEventList.size();
        ArrayList<TSpanEvent> tSpanEventList = new ArrayList<TSpanEvent>(eventSize);
        for (SpanEvent spanEvent : spanEventList) {
            TSpanEvent tSpanEvent = this.buildTSpanEvent(spanEvent, context);
            this.spanPostProcessor.postProcess(context, spanEvent, tSpanEvent);
            context.next();
            tSpanEventList.add(tSpanEvent);
        }
        return tSpanEventList;
    }

    @VisibleForTesting
    TSpanChunk buildTSpanChunk(SpanChunk spanChunk) {
        TSpanChunk tSpanChunk = new TSpanChunk();
        tSpanChunk.setApplicationName(this.applicationName);
        tSpanChunk.setAgentId(this.agentId);
        tSpanChunk.setAgentStartTime(this.agentStartTime);
        tSpanChunk.setApplicationServiceType(this.applicationServiceType);
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        ByteBuffer transactionId = this.transactionIdEncoder.encodeTransactionId(traceId);
        tSpanChunk.setTransactionId(transactionId);
        tSpanChunk.setSpanId(traceId.getSpanId());
        Shared shared = traceRoot.getShared();
        tSpanChunk.setEndPoint(shared.getEndPoint());
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            Context context = this.spanPostProcessor.newContext(spanChunk, tSpanChunk);
            List<TSpanEvent> tSpanEvents = this.buildTSpanEventList(spanEventList, context);
            context.finish();
            tSpanChunk.setSpanEventList(tSpanEvents);
        }
        return tSpanChunk;
    }

    @VisibleForTesting
    TSpanEvent buildTSpanEvent(SpanEvent spanEvent, Context context) {
        List<Annotation> annotations;
        LocalAsyncId localAsyncId;
        AsyncId asyncIdObject;
        TSpanEvent tSpanEvent = new TSpanEvent();
        if (spanEvent.getElapsedTime() != 0) {
            tSpanEvent.setEndElapsed(spanEvent.getElapsedTime());
        }
        tSpanEvent.setSequence(spanEvent.getSequence());
        tSpanEvent.setServiceType(spanEvent.getServiceType());
        tSpanEvent.setEndPoint(spanEvent.getEndPoint());
        if (spanEvent.getDepth() != -1) {
            tSpanEvent.setDepth(spanEvent.getDepth());
        }
        if (spanEvent.getNextSpanId() != -1L) {
            tSpanEvent.setNextSpanId(spanEvent.getNextSpanId());
        }
        tSpanEvent.setDestinationId(spanEvent.getDestinationId());
        tSpanEvent.setApiId(spanEvent.getApiId());
        IntStringValue exceptionInfo = spanEvent.getExceptionInfo();
        if (exceptionInfo != null) {
            TIntStringValue tIntStringValue = this.buildTIntStringValue(exceptionInfo);
            tSpanEvent.setExceptionInfo(tIntStringValue);
        }
        if ((asyncIdObject = spanEvent.getAsyncIdObject()) != null) {
            tSpanEvent.setNextAsyncId(asyncIdObject.getAsyncId());
        }
        if ((localAsyncId = spanEvent.getLocalAsyncId()) != null) {
            tSpanEvent.setAsyncId(localAsyncId.getAsyncId());
            tSpanEvent.setAsyncSequence(localAsyncId.getSequence());
        }
        if (CollectionUtils.hasLength(annotations = spanEvent.getAnnotations())) {
            List<TAnnotation> tAnnotations = this.buildTAnnotation(annotations);
            tSpanEvent.setAnnotations(tAnnotations);
        }
        return tSpanEvent;
    }

    private TIntStringValue buildTIntStringValue(IntStringValue exceptionInfo) {
        TIntStringValue tIntStringValue = new TIntStringValue(exceptionInfo.getIntValue());
        String stringValue = exceptionInfo.getStringValue();
        if (stringValue != null) {
            tIntStringValue.setStringValue(stringValue);
        }
        return tIntStringValue;
    }

    @VisibleForTesting
    List<TAnnotation> buildTAnnotation(List<Annotation> annotations) {
        ArrayList<TAnnotation> tAnnotationList = new ArrayList<TAnnotation>(annotations.size());
        for (Annotation annotation : annotations) {
            TAnnotation tAnnotation = new TAnnotation(annotation.getAnnotationKey());
            TAnnotationValue tAnnotationValue = AnnotationValueMapper.buildTAnnotationValue(annotation.getValue());
            if (tAnnotationValue != null) {
                tAnnotation.setValue(tAnnotationValue);
            }
            tAnnotationList.add(tAnnotation);
        }
        return tAnnotationList;
    }

    public String toString() {
        return "SpanThriftMessageConverter{agentId='" + this.agentId + '\'' + ", applicationName='" + this.applicationName + '\'' + ", agentStartTime=" + this.agentStartTime + ", applicationServiceType=" + this.applicationServiceType + '}';
    }
}

