/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.util.NetworkUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.SystemPropertyKey;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.DefaultAgentInformation;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.module.ApplicationServerType;
import com.navercorp.pinpoint.profiler.context.module.Container;
import com.navercorp.pinpoint.profiler.util.RuntimeMXBeanUtils;

public class AgentInformationProvider
implements Provider<AgentInformation> {
    private final String agentId;
    private final String applicationName;
    private final boolean isContainer;
    private final long agentStartTime;
    private final ServiceType serverType;

    @Inject
    public AgentInformationProvider(@AgentId String agentId, @ApplicationName String applicationName, @Container boolean isContainer, @AgentStartTime long agentStartTime, @ApplicationServerType ServiceType serverType) {
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName must not be null");
        }
        if (serverType == null) {
            throw new NullPointerException("serverType must not be null");
        }
        this.agentId = this.checkId("agentId", agentId);
        this.applicationName = this.checkId("applicationName", applicationName);
        this.isContainer = isContainer;
        this.agentStartTime = agentStartTime;
        this.serverType = serverType;
    }

    public AgentInformation get() {
        return this.createAgentInformation();
    }

    public AgentInformation createAgentInformation() {
        String machineName = NetworkUtils.getHostName();
        String hostIp = NetworkUtils.getRepresentationHostIp();
        int pid = RuntimeMXBeanUtils.getPid();
        String jvmVersion = JvmUtils.getSystemProperty((SystemPropertyKey)SystemPropertyKey.JAVA_VERSION);
        return new DefaultAgentInformation(this.agentId, this.applicationName, this.isContainer, this.agentStartTime, pid, machineName, hostIp, this.serverType, jvmVersion, "1.8.5");
    }

    private String checkId(String keyName, String id) {
        if (!IdValidateUtils.validateId((String)id)) {
            throw new IllegalArgumentException("invalid " + keyName + "=" + id);
        }
        return id;
    }
}

