/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util.jdk;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.util.jdk.PinpointThreadLocalRandomFactory;
import com.navercorp.pinpoint.bootstrap.util.jdk.ThreadLocalRandomFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public class ThreadLocalRandomUtils {
    private static final PLogger LOGGER = PLoggerFactory.getLogger(ThreadLocalRandomUtils.class);
    private static final ThreadLocalRandomFactory THREAD_LOCAL_RANDOM_FACTORY = ThreadLocalRandomUtils.createThreadLocalRandomFactory();
    private static final String DEFAULT_THREAD_LOCAL_RANDOM_FACTORY = "com.navercorp.pinpoint.bootstrap.util.jdk.JdkThreadLocalRandomFactory";

    private ThreadLocalRandomUtils() {
        throw new IllegalAccessError();
    }

    private static ThreadLocalRandomFactory createThreadLocalRandomFactory() {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        if (jvmVersion == JvmVersion.JAVA_6) {
            return new PinpointThreadLocalRandomFactory();
        }
        if (jvmVersion.onOrAfter(JvmVersion.JAVA_7)) {
            try {
                ClassLoader classLoader = ThreadLocalRandomUtils.class.getClassLoader();
                Class<?> threadLocalRandomFactoryClass = Class.forName(DEFAULT_THREAD_LOCAL_RANDOM_FACTORY, true, classLoader);
                Constructor<?> constructor = threadLocalRandomFactoryClass.getDeclaredConstructor(new Class[0]);
                return (ThreadLocalRandomFactory)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                ThreadLocalRandomUtils.logError(e);
            }
            catch (InstantiationException e) {
                ThreadLocalRandomUtils.logError(e);
            }
            catch (IllegalAccessException e) {
                ThreadLocalRandomUtils.logError(e);
            }
            catch (NoSuchMethodException e) {
                ThreadLocalRandomUtils.logError(e);
            }
            catch (InvocationTargetException e) {
                ThreadLocalRandomUtils.logError(e);
            }
            return new PinpointThreadLocalRandomFactory();
        }
        throw new RuntimeException("Unsupported jvm version " + jvmVersion);
    }

    private static void logError(Exception e) {
        LOGGER.info("JdkThreadLocalRandomFactory not found. Caused by:{}", (Object)e.getMessage(), (Object)e);
    }

    public static Random current() {
        return THREAD_LOCAL_RANDOM_FACTORY.current();
    }
}

