/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.classloader;

import com.navercorp.pinpoint.bootstrap.java9.classloader.Java9BootLoader;
import com.navercorp.pinpoint.bootstrap.java9.classloader.MergedEnumeration2;
import com.navercorp.pinpoint.bootstrap.java9.classloader.ProfilerLibClass;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;

public class Java9ClassLoader
extends URLClassLoader {
    private final Java9BootLoader bootLoader = new Java9BootLoader();
    private final ClassLoader parent;
    private final ProfilerLibClass profilerLibClass;

    public Java9ClassLoader(String name, URL[] urls, ClassLoader parent, List<String> libClass) {
        super(name, urls, parent);
        this.parent = parent;
        if (libClass == null) {
            throw new NullPointerException("profilerLibClass must not be null");
        }
        this.profilerLibClass = new ProfilerLibClass(libClass);
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        if (this.getName().equals(moduleName)) {
            return this.findResource(name);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    private Object getClassLoadingLock0(String name) {
        return this.getClassLoadingLock(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.parent != null ? this.parent.getResource(name) : this.bootLoader.findResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> currentResource = this.findResources(name);
        Enumeration<URL> parentResource = this.parent != null ? this.parent.getResources(name) : this.bootLoader.findResources(name);
        return new MergedEnumeration2<URL>(currentResource, parentResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock0(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                if (this.onLoadClass(name)) {
                    clazz = this.findClass(name);
                } else {
                    try {
                        clazz = this.parent != null ? this.parent.loadClass(name) : this.bootLoader.findBootstrapClassOrNull(this, name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        clazz = this.findClass(name);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private boolean onLoadClass(String name) {
        return this.profilerLibClass.onLoadClass(name);
    }

    public String toString() {
        return "Java9ClassLoader{name=" + this.getName() + "} " + super.toString();
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            throw new IllegalStateException("registerAsParallelCapable() fail");
        }
    }
}

