/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.StringUtils;

public enum ByteSizeUnit {
    BYTES('B', 'b', 1L),
    KILO_BYTES('K', 'k', 1024L),
    MEGA_BYTES('M', 'm', 0x100000L),
    GIGA_BYTES('G', 'g', 0x40000000L),
    TERA_BYTES('T', 't', 0x10000000000L);

    private static final long BYTES_SIZE = 1L;
    private static final long KILO_SIZE = 1024L;
    private static final long MEGA_SIZE = 0x100000L;
    private static final long GIGA_SIZE = 0x40000000L;
    private static final long TERA_SIZE = 0x10000000000L;
    private final char unitChar1;
    private final char unitChar2;
    private final long unitSize;
    private final long maxSize;
    private final long intMaxSize;

    private ByteSizeUnit(char unitChar1, char unitChar2, long unitSize) {
        this.unitChar1 = unitChar1;
        this.unitChar2 = unitChar2;
        this.unitSize = unitSize;
        this.maxSize = Long.MAX_VALUE / unitSize;
        this.intMaxSize = Integer.MAX_VALUE / unitSize;
    }

    public long toBytesSize(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value < 0");
        }
        if (value > this.maxSize) {
            throw new IllegalArgumentException("value > " + this.maxSize);
        }
        return value * this.unitSize;
    }

    public int toBytesSizeAsInt(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value < 0");
        }
        if (value > this.intMaxSize) {
            throw new IllegalArgumentException("value > " + this.intMaxSize);
        }
        return (int)(value * this.unitSize);
    }

    char getUnitChar1() {
        return this.unitChar1;
    }

    char getUnitChar2() {
        return this.unitChar2;
    }

    public long getUnitSize() {
        return this.unitSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public static long getByteSize(String value, long defaultValue) {
        try {
            return ByteSizeUnit.getByteSize(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getByteSize(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("size must not be empty");
        }
        char sizeUnitChar = value.charAt(value.length() - 1);
        if (sizeUnitChar == ByteSizeUnit.BYTES.unitChar1 || sizeUnitChar == ByteSizeUnit.BYTES.unitChar2) {
            return ByteSizeUnit.getByteSize0(value.substring(0, value.length() - 1));
        }
        return ByteSizeUnit.getByteSize0(value);
    }

    private static long getByteSize0(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("size must not be empty");
        }
        char sizeUnitChar = value.charAt(value.length() - 1);
        for (ByteSizeUnit byteSizeUnit : ByteSizeUnit.values()) {
            if (byteSizeUnit == BYTES || sizeUnitChar != byteSizeUnit.unitChar1 && sizeUnitChar != byteSizeUnit.unitChar2) continue;
            long numberValue = ByteSizeUnit.getLong(value.substring(0, value.length() - 1));
            return byteSizeUnit.toBytesSize(numberValue);
        }
        long numberValue = ByteSizeUnit.getLong(value);
        return BYTES.toBytesSize(numberValue);
    }

    private static long getLong(String value) {
        try {
            return Long.parseLong(value, 10);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

