/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringEscapeUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertiesConfiguration
extends PropertiesConfiguration {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MALFORMED_XML_EXCEPTION = "Malformed XML";

    public XMLPropertiesConfiguration() {
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(String string) throws ConfigurationException {
        super(string);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(Element element) throws ConfigurationException {
        this.setEncoding(DEFAULT_ENCODING);
        this.load(element);
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(this.getClass().getClassLoader().getResourceAsStream("properties.dtd"));
                }
            });
            xMLReader.setContentHandler(new XMLPropertiesHandler());
            xMLReader.parse(new InputSource(reader));
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to parse the configuration file", exception);
        }
    }

    public void load(Element element) throws ConfigurationException {
        if (!element.getNodeName().equals("properties")) {
            throw new ConfigurationException(MALFORMED_XML_EXCEPTION);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("comment")) {
                this.setHeader(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("entry")) {
                String string = ((Element)node).getAttribute("key");
                this.addProperty(string, node.getTextContent());
                continue;
            }
            throw new ConfigurationException(MALFORMED_XML_EXCEPTION);
        }
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(writer);
        String string = this.getEncoding() != null ? this.getEncoding() : DEFAULT_ENCODING;
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
        printWriter.println("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">");
        printWriter.println("<properties>");
        if (this.getHeader() != null) {
            printWriter.println("  <comment>" + StringEscapeUtils.escapeXml(this.getHeader()) + "</comment>");
        }
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Object object = this.getProperty(string2);
            if (object instanceof List) {
                this.writeProperty(printWriter, string2, (List)object);
                continue;
            }
            this.writeProperty(printWriter, string2, object);
        }
        printWriter.println("</properties>");
        printWriter.flush();
    }

    private void writeProperty(PrintWriter printWriter, String string, Object object) {
        String string2 = StringEscapeUtils.escapeXml(string);
        if (object != null) {
            String string3 = StringEscapeUtils.escapeXml(String.valueOf(object));
            string3 = StringUtils.replace(string3, String.valueOf(this.getListDelimiter()), "\\" + this.getListDelimiter());
            printWriter.println("  <entry key=\"" + string2 + "\">" + string3 + "</entry>");
        } else {
            printWriter.println("  <entry key=\"" + string2 + "\"/>");
        }
    }

    private void writeProperty(PrintWriter printWriter, String string, List<?> list) {
        for (Object obj : list) {
            this.writeProperty(printWriter, string, obj);
        }
    }

    public void save(Document document, Node node) {
        Object object;
        Element element = document.createElement("properties");
        node.appendChild(element);
        if (this.getHeader() != null) {
            object = document.createElement("comment");
            element.appendChild((Node)object);
            object.setTextContent(StringEscapeUtils.escapeXml(this.getHeader()));
        }
        object = this.getKeys();
        while (object.hasNext()) {
            String string = (String)object.next();
            Object object2 = this.getProperty(string);
            if (object2 instanceof List) {
                this.writeProperty(document, (Node)element, string, (List)object2);
                continue;
            }
            this.writeProperty(document, (Node)element, string, object2);
        }
    }

    private void writeProperty(Document document, Node node, String string, Object object) {
        Element element = document.createElement("entry");
        node.appendChild(element);
        String string2 = StringEscapeUtils.escapeXml(string);
        element.setAttribute("key", string2);
        if (object != null) {
            String string3 = StringEscapeUtils.escapeXml(String.valueOf(object));
            string3 = StringUtils.replace(string3, String.valueOf(this.getListDelimiter()), "\\" + this.getListDelimiter());
            element.setTextContent(string3);
        }
    }

    private void writeProperty(Document document, Node node, String string, List<?> list) {
        for (Object obj : list) {
            this.writeProperty(document, node, string, obj);
        }
    }

    private class XMLPropertiesHandler
    extends DefaultHandler {
        private String key;
        private StringBuilder value = new StringBuilder();
        private boolean inCommentElement;
        private boolean inEntryElement;

        private XMLPropertiesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("comment".equals(string3)) {
                this.inCommentElement = true;
            }
            if ("entry".equals(string3)) {
                this.key = attributes.getValue("key");
                this.inEntryElement = true;
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (this.inCommentElement) {
                XMLPropertiesConfiguration.this.setHeader(this.value.toString());
                this.inCommentElement = false;
            }
            if (this.inEntryElement) {
                XMLPropertiesConfiguration.this.addProperty(this.key, this.value.toString());
                this.inEntryElement = false;
            }
            this.value = new StringBuilder();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.value.append(cArray, n, n2);
        }
    }
}

