/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.CombinedConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationBuilder;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.EnvironmentConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystemBased;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalINIConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.JNDIConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SystemConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.XMLConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.XMLPropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanDeclaration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanFactory;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanHelper;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.CatalogResolver;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.EntityRegistry;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.EntityResolverSupport;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.OverrideCombiner;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.UnionCombiner;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrLookup;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationBuilder
extends XMLConfiguration
implements ConfigurationBuilder {
    public static final String ADDITIONAL_NAME = DefaultConfigurationBuilder.class.getName() + "/ADDITIONAL_CONFIG";
    public static final int EVENT_ERR_LOAD_OPTIONAL = 51;
    static final String CONFIG_BEAN_FACTORY_NAME = DefaultConfigurationBuilder.class.getName() + ".CONFIG_BEAN_FACTORY_NAME";
    static final String ATTR_NAME = "[@config-name]";
    static final String ATTR_ATNAME = "at";
    static final String ATTR_AT_RES = "[@config-at]";
    static final String ATTR_AT = "[@at]";
    static final String ATTR_OPTIONALNAME = "optional";
    static final String ATTR_OPTIONAL_RES = "[@config-optional]";
    static final String ATTR_OPTIONAL = "[@optional]";
    static final String ATTR_FILENAME = "[@fileName]";
    static final String ATTR_FORCECREATE = "[@config-forceCreate]";
    static final String KEY_SYSTEM_PROPS = "[@systemProperties]";
    static final String SEC_HEADER = "header";
    static final String KEY_UNION = "additional";
    static final String[] CONFIG_SECTIONS = new String[]{"additional", "override", "header"};
    static final String KEY_OVERRIDE = "override";
    static final String KEY_OVERRIDE_LIST = "header.combiner.override.list-nodes.node";
    static final String KEY_ADDITIONAL_LIST = "header.combiner.additional.list-nodes.node";
    static final String KEY_CONFIGURATION_PROVIDERS = "header.providers.provider";
    static final String KEY_PROVIDER_KEY = "[@config-tag]";
    static final String KEY_CONFIGURATION_LOOKUPS = "header.lookups.lookup";
    static final String KEY_ENTITY_RESOLVER = "header.entity-resolver";
    static final String KEY_LOOKUP_KEY = "[@config-prefix]";
    static final String FILE_SYSTEM = "header.fileSystem";
    static final String KEY_RESULT = "header.result";
    static final String KEY_COMBINER = "header.result.nodeCombiner";
    static final String EXT_XML = ".xml";
    private static final ConfigurationProvider PROPERTIES_PROVIDER = new FileExtensionConfigurationProvider(XMLPropertiesConfiguration.class, PropertiesConfiguration.class, ".xml");
    private static final ConfigurationProvider XML_PROVIDER = new XMLConfigurationProvider();
    private static final ConfigurationProvider JNDI_PROVIDER = new ConfigurationProvider(JNDIConfiguration.class);
    private static final ConfigurationProvider SYSTEM_PROVIDER = new ConfigurationProvider(SystemConfiguration.class);
    private static final ConfigurationProvider INI_PROVIDER = new FileConfigurationProvider(HierarchicalINIConfiguration.class);
    private static final ConfigurationProvider ENV_PROVIDER = new ConfigurationProvider(EnvironmentConfiguration.class);
    private static final ConfigurationProvider PLIST_PROVIDER = new FileExtensionConfigurationProvider("com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.XMLPropertyListConfiguration", "com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.PropertyListConfiguration", ".xml");
    private static final ConfigurationProvider BUILDER_PROVIDER = new ConfigurationBuilderProvider();
    private static final String[] DEFAULT_TAGS = new String[]{"properties", "xml", "hierarchicalXml", "jndi", "system", "plist", "configuration", "ini", "env"};
    private static final ConfigurationProvider[] DEFAULT_PROVIDERS = new ConfigurationProvider[]{PROPERTIES_PROVIDER, XML_PROVIDER, XML_PROVIDER, JNDI_PROVIDER, SYSTEM_PROVIDER, PLIST_PROVIDER, BUILDER_PROVIDER, INI_PROVIDER, ENV_PROVIDER};
    private static final long serialVersionUID = -3113777854714492123L;
    private final StrLookup combinedConfigLookup = new StrLookup(){

        public String lookup(String string) {
            if (DefaultConfigurationBuilder.this.constructedConfiguration != null) {
                Object object = DefaultConfigurationBuilder.this.constructedConfiguration.resolveContainerStore(string);
                return object != null ? object.toString() : null;
            }
            return null;
        }
    };
    private CombinedConfiguration constructedConfiguration;
    private final Map<String, ConfigurationProvider> providers = new HashMap<String, ConfigurationProvider>();
    private String configurationBasePath;

    public DefaultConfigurationBuilder() {
        this.registerDefaultProviders();
        this.registerBeanFactory();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DefaultConfigurationBuilder(File file) {
        this();
        this.setFile(file);
    }

    public DefaultConfigurationBuilder(String string) throws ConfigurationException {
        this();
        this.setFileName(string);
    }

    public DefaultConfigurationBuilder(URL uRL) throws ConfigurationException {
        this();
        this.setURL(uRL);
    }

    public String getConfigurationBasePath() {
        return this.configurationBasePath != null ? this.configurationBasePath : this.getBasePath();
    }

    public void setConfigurationBasePath(String string) {
        this.configurationBasePath = string;
    }

    public void addConfigurationProvider(String string, ConfigurationProvider configurationProvider) {
        if (string == null) {
            throw new IllegalArgumentException("Tag name must not be null!");
        }
        if (configurationProvider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.providers.put(string, configurationProvider);
    }

    public ConfigurationProvider removeConfigurationProvider(String string) {
        return this.providers.remove(string);
    }

    public ConfigurationProvider providerForTag(String string) {
        return this.providers.get(string);
    }

    @Override
    public Configuration getConfiguration() throws ConfigurationException {
        return this.getConfiguration(true);
    }

    public CombinedConfiguration getConfiguration(boolean bl) throws ConfigurationException {
        CombinedConfiguration combinedConfiguration;
        if (bl) {
            this.load();
        }
        this.initFileSystem();
        this.initSystemProperties();
        this.configureEntityResolver();
        this.registerConfiguredProviders();
        this.registerConfiguredLookups();
        this.constructedConfiguration = combinedConfiguration = this.createResultConfiguration();
        List<SubnodeConfiguration> list = this.fetchTopLevelOverrideConfigs();
        list.addAll(this.fetchChildConfigs(KEY_OVERRIDE));
        this.initCombinedConfiguration(combinedConfiguration, list, KEY_OVERRIDE_LIST);
        List<SubnodeConfiguration> list2 = this.fetchChildConfigs(KEY_UNION);
        if (!list2.isEmpty()) {
            CombinedConfiguration combinedConfiguration2 = this.createAdditionalsConfiguration(combinedConfiguration);
            combinedConfiguration.addConfiguration(combinedConfiguration2, ADDITIONAL_NAME);
            this.initCombinedConfiguration(combinedConfiguration2, list2, KEY_ADDITIONAL_LIST);
        }
        return combinedConfiguration;
    }

    protected CombinedConfiguration createResultConfiguration() throws ConfigurationException {
        XMLBeanDeclaration xMLBeanDeclaration = new XMLBeanDeclaration(this, KEY_RESULT, true);
        CombinedConfiguration combinedConfiguration = (CombinedConfiguration)BeanHelper.createBean(xMLBeanDeclaration, CombinedConfiguration.class);
        if (this.getMaxIndex(KEY_COMBINER) < 0) {
            combinedConfiguration.setNodeCombiner(new OverrideCombiner());
        }
        return combinedConfiguration;
    }

    protected CombinedConfiguration createAdditionalsConfiguration(CombinedConfiguration combinedConfiguration) {
        CombinedConfiguration combinedConfiguration2 = new CombinedConfiguration(new UnionCombiner());
        combinedConfiguration2.setDelimiterParsingDisabled(combinedConfiguration.isDelimiterParsingDisabled());
        combinedConfiguration2.setForceReloadCheck(combinedConfiguration.isForceReloadCheck());
        combinedConfiguration2.setIgnoreReloadExceptions(combinedConfiguration.isIgnoreReloadExceptions());
        return combinedConfiguration2;
    }

    protected void initCombinedConfiguration(CombinedConfiguration combinedConfiguration, List<? extends HierarchicalConfiguration> list, String string) throws ConfigurationException {
        List<Object> list2 = this.getList(string);
        for (Object object : list2) {
            combinedConfiguration.getNodeCombiner().addListNode((String)object);
        }
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            AbstractConfiguration abstractConfiguration;
            ConfigurationDeclaration configurationDeclaration = new ConfigurationDeclaration(this, hierarchicalConfiguration);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating configuration " + configurationDeclaration.getBeanClassName() + " with name " + configurationDeclaration.getConfiguration().getString(ATTR_NAME));
            }
            if ((abstractConfiguration = this.createConfigurationAt(configurationDeclaration)) == null) continue;
            combinedConfiguration.addConfiguration(abstractConfiguration, configurationDeclaration.getConfiguration().getString(ATTR_NAME), configurationDeclaration.getAt());
        }
    }

    protected void registerDefaultProviders() {
        for (int i = 0; i < DEFAULT_TAGS.length; ++i) {
            this.addConfigurationProvider(DEFAULT_TAGS[i], DEFAULT_PROVIDERS[i]);
        }
    }

    protected void registerConfiguredProviders() throws ConfigurationException {
        List<HierarchicalConfiguration> list = this.configurationsAt(KEY_CONFIGURATION_PROVIDERS);
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            XMLBeanDeclaration xMLBeanDeclaration = new XMLBeanDeclaration(hierarchicalConfiguration);
            String string = hierarchicalConfiguration.getString(KEY_PROVIDER_KEY);
            this.addConfigurationProvider(string, (ConfigurationProvider)BeanHelper.createBean(xMLBeanDeclaration));
        }
    }

    protected void registerConfiguredLookups() throws ConfigurationException {
        List<HierarchicalConfiguration> list = this.configurationsAt(KEY_CONFIGURATION_LOOKUPS);
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            XMLBeanDeclaration xMLBeanDeclaration = new XMLBeanDeclaration(hierarchicalConfiguration);
            String string = hierarchicalConfiguration.getString(KEY_LOOKUP_KEY);
            StrLookup strLookup = (StrLookup)BeanHelper.createBean(xMLBeanDeclaration);
            BeanHelper.setProperty(strLookup, "configuration", this);
            ConfigurationInterpolator.registerGlobalLookup(string, strLookup);
            this.getInterpolator().registerLookup(string, strLookup);
        }
    }

    protected void initFileSystem() throws ConfigurationException {
        if (this.getMaxIndex(FILE_SYSTEM) == 0) {
            SubnodeConfiguration subnodeConfiguration = this.configurationAt(FILE_SYSTEM);
            XMLBeanDeclaration xMLBeanDeclaration = new XMLBeanDeclaration(subnodeConfiguration);
            this.setFileSystem((FileSystem)BeanHelper.createBean(xMLBeanDeclaration));
        }
    }

    protected void initSystemProperties() throws ConfigurationException {
        String string = this.getString(KEY_SYSTEM_PROPS);
        if (string != null) {
            try {
                SystemConfiguration.setSystemProperties(this.getConfigurationBasePath(), string);
            }
            catch (Exception exception) {
                throw new ConfigurationException("Error setting system properties from " + string, exception);
            }
        }
    }

    protected void configureEntityResolver() throws ConfigurationException {
        if (this.getMaxIndex(KEY_ENTITY_RESOLVER) == 0) {
            XMLBeanDeclaration xMLBeanDeclaration = new XMLBeanDeclaration(this, KEY_ENTITY_RESOLVER, true);
            EntityResolver entityResolver = (EntityResolver)BeanHelper.createBean(xMLBeanDeclaration, CatalogResolver.class);
            BeanHelper.setProperty(entityResolver, "fileSystem", this.getFileSystem());
            BeanHelper.setProperty(entityResolver, "baseDir", this.getBasePath());
            BeanHelper.setProperty(entityResolver, "substitutor", this.getSubstitutor());
            this.setEntityResolver(entityResolver);
        }
    }

    @Override
    protected Object interpolate(Object object) {
        Object object2 = super.interpolate(object);
        if (this.constructedConfiguration != null) {
            object2 = this.constructedConfiguration.interpolate(object2);
        }
        return object2;
    }

    private AbstractConfiguration createConfigurationAt(ConfigurationDeclaration configurationDeclaration) throws ConfigurationException {
        try {
            return (AbstractConfiguration)BeanHelper.createBean(configurationDeclaration);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    private List<SubnodeConfiguration> fetchChildConfigs(ConfigurationNode configurationNode) {
        List<ConfigurationNode> list = configurationNode.getChildren();
        ArrayList<SubnodeConfiguration> arrayList = new ArrayList<SubnodeConfiguration>(list.size());
        for (ConfigurationNode configurationNode2 : list) {
            arrayList.add(this.createSubnodeConfiguration(configurationNode2));
        }
        return arrayList;
    }

    private List<SubnodeConfiguration> fetchChildConfigs(String string) {
        List<ConfigurationNode> list = this.fetchNodeList(string);
        if (list.size() > 0) {
            return this.fetchChildConfigs(list.get(0));
        }
        return Collections.emptyList();
    }

    private List<SubnodeConfiguration> fetchTopLevelOverrideConfigs() {
        List<SubnodeConfiguration> list = this.fetchChildConfigs(this.getRootNode());
        Iterator<SubnodeConfiguration> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            String string = iterator.next().getRootNode().getName();
            for (int i = 0; i < CONFIG_SECTIONS.length; ++i) {
                if (!CONFIG_SECTIONS[i].equals(string)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeanFactory() {
        Class<DefaultConfigurationBuilder> clazz = DefaultConfigurationBuilder.class;
        synchronized (DefaultConfigurationBuilder.class) {
            if (!BeanHelper.registeredFactoryNames().contains(CONFIG_BEAN_FACTORY_NAME)) {
                BeanHelper.registerBeanFactory(CONFIG_BEAN_FACTORY_NAME, new ConfigurationBeanFactory());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static class ConfigurationBuilderProvider
    extends ConfigurationProvider {
        public ConfigurationBuilderProvider() {
            super(DefaultConfigurationBuilder.class);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            DefaultConfigurationBuilder defaultConfigurationBuilder = (DefaultConfigurationBuilder)super.getConfiguration(configurationDeclaration);
            return defaultConfigurationBuilder.getConfiguration(true);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            return new CombinedConfiguration();
        }

        protected void initBeanInstance(Object object, BeanDeclaration beanDeclaration) throws Exception {
            ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)beanDeclaration;
            ConfigurationBuilderProvider.initChildBuilder(configurationDeclaration.getConfigurationBuilder(), (DefaultConfigurationBuilder)object);
            super.initBeanInstance(object, beanDeclaration);
        }

        private static void initChildBuilder(DefaultConfigurationBuilder defaultConfigurationBuilder, DefaultConfigurationBuilder defaultConfigurationBuilder2) {
            defaultConfigurationBuilder2.setAttributeSplittingDisabled(defaultConfigurationBuilder.isAttributeSplittingDisabled());
            defaultConfigurationBuilder2.setBasePath(defaultConfigurationBuilder.getBasePath());
            defaultConfigurationBuilder2.setDelimiterParsingDisabled(defaultConfigurationBuilder.isDelimiterParsingDisabled());
            defaultConfigurationBuilder2.setListDelimiter(defaultConfigurationBuilder.getListDelimiter());
            defaultConfigurationBuilder2.setThrowExceptionOnMissing(defaultConfigurationBuilder.isThrowExceptionOnMissing());
            defaultConfigurationBuilder2.setLogger(defaultConfigurationBuilder.getLogger());
            defaultConfigurationBuilder2.clearConfigurationListeners();
            for (ConfigurationListener object : defaultConfigurationBuilder.getConfigurationListeners()) {
                defaultConfigurationBuilder2.addConfigurationListener(object);
            }
            defaultConfigurationBuilder2.clearErrorListeners();
            for (ConfigurationErrorListener configurationErrorListener : defaultConfigurationBuilder.getErrorListeners()) {
                defaultConfigurationBuilder2.addErrorListener(configurationErrorListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileExtensionConfigurationProvider
    extends FileConfigurationProvider {
        private Class<?> matchingClass;
        private String matchingClassName;
        private Class<?> defaultClass;
        private String defaultClassName;
        private String fileExtension;

        public FileExtensionConfigurationProvider(Class<?> clazz, Class<?> clazz2, String string) {
            this.matchingClass = clazz;
            this.defaultClass = clazz2;
            this.fileExtension = string;
        }

        public FileExtensionConfigurationProvider(String string, String string2, String string3) {
            this.matchingClassName = string;
            this.defaultClassName = string2;
            this.fileExtension = string3;
        }

        protected synchronized Class<?> fetchMatchingClass() throws Exception {
            if (this.matchingClass == null) {
                this.matchingClass = this.loadClass(this.matchingClassName);
            }
            return this.matchingClass;
        }

        protected synchronized Class<?> fetchDefaultClass() throws Exception {
            if (this.defaultClass == null) {
                this.defaultClass = this.loadClass(this.defaultClassName);
            }
            return this.defaultClass;
        }

        @Override
        protected Object createBeanInstance(Class<?> clazz, BeanDeclaration beanDeclaration) throws Exception {
            String string = ((ConfigurationDeclaration)beanDeclaration).getConfiguration().getString(DefaultConfigurationBuilder.ATTR_FILENAME);
            if (string != null && string.toLowerCase().trim().endsWith(this.fileExtension)) {
                return super.createBeanInstance(this.fetchMatchingClass(), beanDeclaration);
            }
            return super.createBeanInstance(this.fetchDefaultClass(), beanDeclaration);
        }
    }

    public static class XMLConfigurationProvider
    extends FileConfigurationProvider {
        public XMLConfigurationProvider() {
            super(XMLConfiguration.class);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            XMLConfiguration xMLConfiguration = (XMLConfiguration)super.getEmptyConfiguration(configurationDeclaration);
            DefaultConfigurationBuilder defaultConfigurationBuilder = configurationDeclaration.getConfigurationBuilder();
            EntityResolver entityResolver = defaultConfigurationBuilder.getEntityResolver();
            if (entityResolver instanceof EntityRegistry) {
                xMLConfiguration.getRegisteredEntities().putAll(defaultConfigurationBuilder.getRegisteredEntities());
            } else {
                xMLConfiguration.setEntityResolver(entityResolver);
            }
            return xMLConfiguration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileConfigurationProvider
    extends ConfigurationProvider {
        public FileConfigurationProvider() {
        }

        public FileConfigurationProvider(Class<?> clazz) {
            super(clazz);
        }

        public FileConfigurationProvider(String string) {
            super(string);
        }

        @Override
        public AbstractConfiguration getConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            DefaultConfigurationBuilder defaultConfigurationBuilder;
            AbstractConfiguration abstractConfiguration = this.getEmptyConfiguration(configurationDeclaration);
            if (abstractConfiguration instanceof FileSystemBased && (defaultConfigurationBuilder = configurationDeclaration.getConfigurationBuilder()).getFileSystem() != null) {
                ((FileSystemBased)((Object)abstractConfiguration)).setFileSystem(defaultConfigurationBuilder.getFileSystem());
            }
            ((FileConfiguration)((Object)abstractConfiguration)).load();
            return abstractConfiguration;
        }

        @Override
        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            AbstractConfiguration abstractConfiguration = super.getConfiguration(configurationDeclaration);
            if (abstractConfiguration instanceof EntityResolverSupport) {
                DefaultConfigurationBuilder defaultConfigurationBuilder = configurationDeclaration.getConfigurationBuilder();
                EntityResolver entityResolver = defaultConfigurationBuilder.getEntityResolver();
                ((EntityResolverSupport)((Object)abstractConfiguration)).setEntityResolver(entityResolver);
            }
            return abstractConfiguration;
        }

        @Override
        protected void initBeanInstance(Object object, BeanDeclaration beanDeclaration) throws Exception {
            FileConfiguration fileConfiguration = (FileConfiguration)object;
            fileConfiguration.setBasePath(((ConfigurationDeclaration)beanDeclaration).getConfigurationBuilder().getConfigurationBasePath());
            super.initBeanInstance(object, beanDeclaration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConfigurationBeanFactory
    implements BeanFactory {
        private Log logger = LogFactory.getLog(DefaultConfigurationBuilder.class);

        ConfigurationBeanFactory() {
        }

        @Override
        public Object createBean(Class<?> clazz, BeanDeclaration beanDeclaration, Object object) throws Exception {
            ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)beanDeclaration;
            String string = configurationDeclaration.getNode().getName();
            ConfigurationProvider configurationProvider = configurationDeclaration.getConfigurationBuilder().providerForTag(string);
            if (configurationProvider == null) {
                throw new ConfigurationRuntimeException("No ConfigurationProvider registered for tag " + string);
            }
            try {
                AbstractConfiguration abstractConfiguration = configurationProvider.getConfiguration(configurationDeclaration);
                this.installInterpolator(configurationDeclaration, abstractConfiguration);
                return abstractConfiguration;
            }
            catch (Exception exception) {
                if (!configurationDeclaration.isOptional()) {
                    throw exception;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Load failed for optional configuration " + string + ": " + exception.getMessage());
                }
                configurationDeclaration.getConfigurationBuilder().fireError(51, configurationDeclaration.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_NAME), null, exception);
                if (configurationDeclaration.isForceCreate()) {
                    try {
                        return configurationProvider.getEmptyConfiguration(configurationDeclaration);
                    }
                    catch (Exception exception2) {
                        this.logger.warn("Could not create instance of optional configuration " + string, exception2);
                    }
                }
                return null;
            }
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return Configuration.class;
        }

        private void installInterpolator(ConfigurationDeclaration configurationDeclaration, AbstractConfiguration abstractConfiguration) {
            ConfigurationInterpolator configurationInterpolator = new ConfigurationInterpolator();
            configurationInterpolator.setDefaultLookup(configurationDeclaration.getConfigurationBuilder().combinedConfigLookup);
            abstractConfiguration.getInterpolator().setParentInterpolator(configurationInterpolator);
        }
    }

    public static class ConfigurationDeclaration
    extends XMLBeanDeclaration {
        private DefaultConfigurationBuilder configurationBuilder;

        public ConfigurationDeclaration(DefaultConfigurationBuilder defaultConfigurationBuilder, HierarchicalConfiguration hierarchicalConfiguration) {
            super(hierarchicalConfiguration);
            this.configurationBuilder = defaultConfigurationBuilder;
        }

        public DefaultConfigurationBuilder getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public String getAt() {
            String string = this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT_RES);
            return string == null ? this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT) : string;
        }

        public boolean isOptional() {
            Boolean bl = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL_RES, null);
            if (bl == null) {
                bl = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL, Boolean.FALSE);
            }
            return bl;
        }

        public boolean isForceCreate() {
            return this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_FORCECREATE, false);
        }

        public String getBeanFactoryName() {
            return CONFIG_BEAN_FACTORY_NAME;
        }

        public String getBeanClassName() {
            return null;
        }

        protected boolean isReservedNode(ConfigurationNode configurationNode) {
            if (super.isReservedNode(configurationNode)) {
                return true;
            }
            return configurationNode.isAttribute() && (DefaultConfigurationBuilder.ATTR_ATNAME.equals(configurationNode.getName()) && configurationNode.getParentNode().getAttributeCount("config-at") == 0 || DefaultConfigurationBuilder.ATTR_OPTIONALNAME.equals(configurationNode.getName()) && configurationNode.getParentNode().getAttributeCount("config-optional") == 0);
        }

        protected Object interpolate(Object object) {
            return this.getConfigurationBuilder().interpolate(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationProvider
    extends DefaultBeanFactory {
        private Class<?> configurationClass;
        private String configurationClassName;

        public ConfigurationProvider() {
            this((Class)null);
        }

        public ConfigurationProvider(Class<?> clazz) {
            this.setConfigurationClass(clazz);
        }

        public ConfigurationProvider(String string) {
            this.setConfigurationClassName(string);
        }

        public Class<?> getConfigurationClass() {
            return this.configurationClass;
        }

        public void setConfigurationClass(Class<?> clazz) {
            this.configurationClass = clazz;
        }

        public String getConfigurationClassName() {
            return this.configurationClassName;
        }

        public void setConfigurationClassName(String string) {
            this.configurationClassName = string;
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            return (AbstractConfiguration)this.createBean(this.fetchConfigurationClass(), configurationDeclaration, null);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration configurationDeclaration) throws Exception {
            return null;
        }

        protected synchronized Class<?> fetchConfigurationClass() throws Exception {
            if (this.getConfigurationClass() == null) {
                this.setConfigurationClass(this.loadClass(this.getConfigurationClassName()));
            }
            return this.getConfigurationClass();
        }

        protected Class<?> loadClass(String string) throws ClassNotFoundException {
            return string != null ? Class.forName(string, true, this.getClass().getClassLoader()) : null;
        }
    }
}

