/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIConfiguration
extends AbstractConfiguration {
    private String prefix;
    private Context context;
    private Context baseContext;
    private Set<String> clearedProperties = new HashSet<String>();

    public JNDIConfiguration() throws NamingException {
        this((String)null);
    }

    public JNDIConfiguration(String string) throws NamingException {
        this(new InitialContext(), string);
    }

    public JNDIConfiguration(Context context) {
        this(context, null);
    }

    public JNDIConfiguration(Context context, String string) {
        this.context = context;
        this.prefix = string;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveGetKeys(Set<String> set, Context context, String string, Set<Context> set2) throws NamingException {
        set2.add(context);
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        try {
            namingEnumeration = context.list("");
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = namingEnumeration.next();
                String string2 = nameClassPair.getName();
                Object object = context.lookup(string2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(string2);
                if (object instanceof Context) {
                    Context context2 = (Context)object;
                    if (set2.contains(context2)) continue;
                    this.recursiveGetKeys(set, context2, stringBuilder.toString(), set2);
                    continue;
                }
                set.add(stringBuilder.toString());
            }
        }
        finally {
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
        }
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getKeys("");
    }

    @Override
    public Iterator<String> getKeys(String string) {
        String[] stringArray = StringUtils.split(string, ".");
        List<String> list = Arrays.asList(stringArray);
        try {
            Context context = this.getContext(list, this.getBaseContext());
            HashSet<String> hashSet = new HashSet<String>();
            if (context != null) {
                this.recursiveGetKeys(hashSet, context, string, new HashSet<Context>());
            } else if (this.containsKey(string)) {
                hashSet.add(string);
            }
            return hashSet.iterator();
        }
        catch (NameNotFoundException nameNotFoundException) {
            return new ArrayList().iterator();
        }
        catch (NamingException namingException) {
            this.fireError(5, null, null, namingException);
            return new ArrayList().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(List<String> list, Context context) throws NamingException {
        if (list == null || list.isEmpty()) {
            return context;
        }
        String string = list.get(0);
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        try {
            namingEnumeration = context.list("");
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = namingEnumeration.next();
                String string2 = nameClassPair.getName();
                Object object = context.lookup(string2);
                if (!(object instanceof Context) || !string2.equals(string)) continue;
                Context context2 = (Context)object;
                Context context3 = this.getContext(list.subList(1, list.size()), context2);
                return context3;
            }
        }
        finally {
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean bl;
        block6: {
            NamingEnumeration<NameClassPair> namingEnumeration = null;
            try {
                namingEnumeration = this.getBaseContext().list("");
                boolean bl2 = bl = !namingEnumeration.hasMore();
                if (namingEnumeration == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (namingEnumeration != null) {
                        namingEnumeration.close();
                    }
                    throw throwable;
                }
                catch (NamingException namingException) {
                    this.fireError(5, null, null, namingException);
                    return true;
                }
            }
            namingEnumeration.close();
        }
        return bl;
    }

    @Override
    public void setProperty(String string, Object object) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void clearProperty(String string) {
        this.clearedProperties.add(string);
    }

    @Override
    public boolean containsKey(String string) {
        if (this.clearedProperties.contains(string)) {
            return false;
        }
        string = string.replaceAll("\\.", "/");
        try {
            this.getBaseContext().lookup(string);
            return true;
        }
        catch (NameNotFoundException nameNotFoundException) {
            return false;
        }
        catch (NamingException namingException) {
            this.fireError(5, string, null, namingException);
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
        this.baseContext = null;
    }

    @Override
    public Object getProperty(String string) {
        if (this.clearedProperties.contains(string)) {
            return null;
        }
        try {
            string = string.replaceAll("\\.", "/");
            return this.getBaseContext().lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (NotContextException notContextException) {
            return null;
        }
        catch (NamingException namingException) {
            this.fireError(5, string, null, namingException);
            return null;
        }
    }

    @Override
    protected void addPropertyDirect(String string, Object object) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Context getBaseContext() throws NamingException {
        if (this.baseContext == null) {
            this.baseContext = (Context)this.getContext().lookup(this.prefix == null ? "" : this.prefix);
        }
        return this.baseContext;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.clearedProperties.clear();
        this.context = context;
    }
}

