/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConversionException;
import com.secnium.iast.thirdparty.org.apache.commons.lang.BooleanUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyConverter {
    static final char LIST_ESC_CHAR = '\\';
    static final String LIST_ESCAPE = String.valueOf('\\');
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final String BIN_PREFIX = "0b";
    private static final int BIN_RADIX = 2;
    private static final Class<?>[] CONSTR_ARGS = new Class[]{String.class};
    private static final String INTERNET_ADDRESS_CLASSNAME = "javax.mail.internet.InternetAddress";

    private PropertyConverter() {
    }

    static Object to(Class<?> clazz, Object object, Object[] objectArray) throws ConversionException {
        if (clazz.isInstance(object)) {
            return object;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return PropertyConverter.toBoolean(object);
        }
        if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            return PropertyConverter.toCharacter(object);
        }
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                return PropertyConverter.toInteger(object);
            }
            if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                return PropertyConverter.toLong(object);
            }
            if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
                return PropertyConverter.toByte(object);
            }
            if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
                return PropertyConverter.toShort(object);
            }
            if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
                return PropertyConverter.toFloat(object);
            }
            if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                return PropertyConverter.toDouble(object);
            }
            if (BigInteger.class.equals(clazz)) {
                return PropertyConverter.toBigInteger(object);
            }
            if (BigDecimal.class.equals(clazz)) {
                return PropertyConverter.toBigDecimal(object);
            }
        } else {
            if (Date.class.equals(clazz)) {
                return PropertyConverter.toDate(object, (String)objectArray[0]);
            }
            if (Calendar.class.equals(clazz)) {
                return PropertyConverter.toCalendar(object, (String)objectArray[0]);
            }
            if (URL.class.equals(clazz)) {
                return PropertyConverter.toURL(object);
            }
            if (Locale.class.equals(clazz)) {
                return PropertyConverter.toLocale(object);
            }
            if (PropertyConverter.isEnum(clazz)) {
                return PropertyConverter.convertToEnum(clazz, object);
            }
            if (Color.class.equals(clazz)) {
                return PropertyConverter.toColor(object);
            }
            if (clazz.getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
                return PropertyConverter.toInternetAddress(object);
            }
            if (InetAddress.class.isAssignableFrom(clazz)) {
                return PropertyConverter.toInetAddress(object);
            }
        }
        throw new ConversionException("The value '" + object + "' (" + object.getClass() + ")" + " can't be converted to a " + clazz.getName() + " object");
    }

    public static Boolean toBoolean(Object object) throws ConversionException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            Boolean bl = BooleanUtils.toBooleanObject((String)object);
            if (bl == null) {
                throw new ConversionException("The value " + object + " can't be converted to a Boolean object");
            }
            return bl;
        }
        throw new ConversionException("The value " + object + " can't be converted to a Boolean object");
    }

    public static Character toCharacter(Object object) throws ConversionException {
        String string = String.valueOf(object);
        if (string.length() == 1) {
            return Character.valueOf(string.charAt(0));
        }
        throw new ConversionException(String.format("The value '%s' cannot be converted to a Character object!", string));
    }

    public static Byte toByte(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Byte.class);
        if (number instanceof Byte) {
            return (Byte)number;
        }
        return new Byte(number.byteValue());
    }

    public static Short toShort(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Short.class);
        if (number instanceof Short) {
            return (Short)number;
        }
        return new Short(number.shortValue());
    }

    public static Integer toInteger(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Integer.class);
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return new Integer(number.intValue());
    }

    public static Long toLong(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Long.class);
        if (number instanceof Long) {
            return (Long)number;
        }
        return new Long(number.longValue());
    }

    public static Float toFloat(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Float.class);
        if (number instanceof Float) {
            return (Float)number;
        }
        return new Float(number.floatValue());
    }

    public static Double toDouble(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, Double.class);
        if (number instanceof Double) {
            return (Double)number;
        }
        return new Double(number.doubleValue());
    }

    public static BigInteger toBigInteger(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, BigInteger.class);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public static BigDecimal toBigDecimal(Object object) throws ConversionException {
        Number number = PropertyConverter.toNumber(object, BigDecimal.class);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.doubleValue());
    }

    static Number toNumber(Object object, Class<?> clazz) throws ConversionException {
        if (object instanceof Number) {
            return (Number)object;
        }
        String string = object.toString();
        if (string.startsWith(HEX_PREFIX)) {
            try {
                return new BigInteger(string.substring(HEX_PREFIX.length()), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Could not convert " + string + " to " + clazz.getName() + "! Invalid hex number.", numberFormatException);
            }
        }
        if (string.startsWith(BIN_PREFIX)) {
            try {
                return new BigInteger(string.substring(BIN_PREFIX.length()), 2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Could not convert " + string + " to " + clazz.getName() + "! Invalid binary number.", numberFormatException);
            }
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(CONSTR_ARGS);
            return (Number)constructor.newInstance(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConversionException("Could not convert " + string + " to " + clazz.getName(), invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new ConversionException("Conversion error when trying to convert " + string + " to " + clazz.getName(), exception);
        }
    }

    public static URL toURL(Object object) throws ConversionException {
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof String) {
            try {
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConversionException("The value " + object + " can't be converted to an URL", malformedURLException);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to an URL");
    }

    public static Locale toLocale(Object object) throws ConversionException {
        if (object instanceof Locale) {
            return (Locale)object;
        }
        if (object instanceof String) {
            List<String> list = PropertyConverter.split((String)object, '_');
            int n = list.size();
            if (n >= 1 && (list.get(0).length() == 2 || list.get(0).length() == 0)) {
                String string = list.get(0);
                String string2 = n >= 2 ? list.get(1) : "";
                String string3 = n >= 3 ? list.get(2) : "";
                return new Locale(string, string2, string3);
            }
            throw new ConversionException("The value " + object + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + object + " can't be converted to a Locale");
    }

    public static List<String> split(String string, char c2, boolean bl) {
        if (string == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (bl2) {
                if (c3 != c2 && c3 != '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c3);
                bl2 = false;
                continue;
            }
            if (c3 == c2) {
                String string2 = stringBuilder.toString();
                if (bl) {
                    string2 = string2.trim();
                }
                arrayList.add(string2);
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c3 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c3);
        }
        if (bl2) {
            stringBuilder.append('\\');
        }
        String string3 = stringBuilder.toString();
        if (bl) {
            string3 = string3.trim();
        }
        arrayList.add(string3);
        return arrayList;
    }

    public static List<String> split(String string, char c2) {
        return PropertyConverter.split(string, c2, true);
    }

    public static String escapeDelimiters(String string, char c2) {
        String string2 = StringUtils.replace(string, LIST_ESCAPE, LIST_ESCAPE + LIST_ESCAPE);
        return PropertyConverter.escapeListDelimiter(string2, c2);
    }

    public static String escapeListDelimiter(String string, char c2) {
        return StringUtils.replace(string, String.valueOf(c2), LIST_ESCAPE + c2);
    }

    public static Color toColor(Object object) throws ConversionException {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String && !StringUtils.isBlank((String)object)) {
            String string = ((String)object).trim();
            int[] nArray = new int[3];
            int n = nArray.length * 2;
            if (string.length() < n) {
                throw new ConversionException("The value " + object + " can't be converted to a Color");
            }
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            try {
                int n2;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = Integer.parseInt(string.substring(2 * n2, 2 * n2 + 2), 16);
                }
                n2 = string.length() >= n + 2 ? Integer.parseInt(string.substring(n, n + 2), 16) : Color.black.getAlpha();
                return new Color(nArray[0], nArray[1], nArray[2], n2);
            }
            catch (Exception exception) {
                throw new ConversionException("The value " + object + " can't be converted to a Color", exception);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a Color");
    }

    static InetAddress toInetAddress(Object object) throws ConversionException {
        if (object instanceof InetAddress) {
            return (InetAddress)object;
        }
        if (object instanceof String) {
            try {
                return InetAddress.getByName((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ConversionException("The value " + object + " can't be converted to a InetAddress", unknownHostException);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a InetAddress");
    }

    static Object toInternetAddress(Object object) throws ConversionException {
        if (object.getClass().getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
            return object;
        }
        if (object instanceof String) {
            try {
                Constructor<?> constructor = Class.forName(INTERNET_ADDRESS_CLASSNAME).getConstructor(String.class);
                return constructor.newInstance(object);
            }
            catch (Exception exception) {
                throw new ConversionException("The value " + object + " can't be converted to a InternetAddress", exception);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a InternetAddress");
    }

    static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum();
    }

    static <E extends Enum<E>> E toEnum(Object object, Class<E> clazz) throws ConversionException {
        if (object.getClass().equals(clazz)) {
            return (E)((Enum)clazz.cast(object));
        }
        if (object instanceof String) {
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (Exception exception) {
                throw new ConversionException("The value " + object + " can't be converted to a " + clazz.getName());
            }
        }
        if (object instanceof Number) {
            try {
                Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                return (E)enumArray[((Number)object).intValue()];
            }
            catch (Exception exception) {
                throw new ConversionException("The value " + object + " can't be converted to a " + clazz.getName());
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a " + clazz.getName());
    }

    public static Date toDate(Object object, String string) throws ConversionException {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof String) {
            try {
                return new SimpleDateFormat(string).parse((String)object);
            }
            catch (ParseException parseException) {
                throw new ConversionException("The value " + object + " can't be converted to a Date", parseException);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object object, String string) throws ConversionException {
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        if (object instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(string).parse((String)object));
                return calendar;
            }
            catch (ParseException parseException) {
                throw new ConversionException("The value " + object + " can't be converted to a Calendar", parseException);
            }
        }
        throw new ConversionException("The value " + object + " can't be converted to a Calendar");
    }

    public static Iterator<?> toIterator(Object object, char c2) {
        return PropertyConverter.flatten(object, c2).iterator();
    }

    private static Collection<?> flatten(Object object, char c2) {
        Object object2;
        if (object instanceof String && ((String)(object2 = (String)object)).indexOf(c2) > 0) {
            return PropertyConverter.split((String)object2, c2);
        }
        object2 = new LinkedList();
        if (object instanceof Iterable) {
            PropertyConverter.flattenIterator((Collection<Object>)object2, ((Iterable)object).iterator(), c2);
        } else if (object instanceof Iterator) {
            PropertyConverter.flattenIterator((Collection<Object>)object2, (Iterator)object, c2);
        } else if (object != null) {
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    object2.addAll(PropertyConverter.flatten(Array.get(object, i), c2));
                }
            } else {
                object2.add(object);
            }
        }
        return object2;
    }

    private static void flattenIterator(Collection<Object> collection, Iterator<?> iterator, char c2) {
        while (iterator.hasNext()) {
            collection.addAll(PropertyConverter.flatten(iterator.next(), c2));
        }
    }

    public static Object interpolate(Object object, AbstractConfiguration abstractConfiguration) {
        if (object instanceof String) {
            return abstractConfiguration.getSubstitutor().replace((String)object);
        }
        return object;
    }

    private static Object convertToEnum(Class<?> clazz, Object object) {
        return PropertyConverter.toEnum(object, clazz.asSubclass(Enum.class));
    }
}

