/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConstantLookup;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.EnvironmentLookup;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationInterpolator
extends StrLookup {
    public static final String PREFIX_SYSPROPERTIES = "sys";
    public static final String PREFIX_CONSTANTS = "const";
    public static final String PREFIX_ENVIRONMENT = "env";
    private static final char PREFIX_SEPARATOR = ':';
    private static Map<String, StrLookup> globalLookups = new HashMap<String, StrLookup>();
    private Map<String, StrLookup> localLookups;
    private StrLookup defaultLookup;
    private ConfigurationInterpolator parentInterpolator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationInterpolator() {
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            this.localLookups = new HashMap<String, StrLookup>(globalLookups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalLookup(String string, StrLookup strLookup) {
        if (string == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (strLookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            globalLookups.put(string, strLookup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deregisterGlobalLookup(String string) {
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            return globalLookups.remove(string) != null;
        }
    }

    public void registerLookup(String string, StrLookup strLookup) {
        if (string == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (strLookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.localLookups.put(string, strLookup);
    }

    public boolean deregisterLookup(String string) {
        return this.localLookups.remove(string) != null;
    }

    public Set<String> prefixSet() {
        return this.localLookups.keySet();
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(StrLookup strLookup) {
        this.defaultLookup = strLookup;
    }

    @Override
    public String lookup(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = this.fetchLookupForPrefix(string2).lookup(string3);
            if (string4 == null && this.getParentInterpolator() != null) {
                string4 = this.getParentInterpolator().lookup(string3);
            }
            if (string4 != null) {
                return string4;
            }
        }
        if ((string2 = this.fetchNoPrefixLookup().lookup(string)) == null && this.getParentInterpolator() != null) {
            string2 = this.getParentInterpolator().lookup(string);
        }
        return string2;
    }

    protected StrLookup fetchNoPrefixLookup() {
        return this.getDefaultLookup() != null ? this.getDefaultLookup() : StrLookup.noneLookup();
    }

    protected StrLookup fetchLookupForPrefix(String string) {
        StrLookup strLookup = this.localLookups.get(string);
        if (strLookup == null) {
            strLookup = StrLookup.noneLookup();
        }
        return strLookup;
    }

    public void registerLocalLookups(ConfigurationInterpolator configurationInterpolator) {
        configurationInterpolator.localLookups.putAll(this.localLookups);
    }

    public void setParentInterpolator(ConfigurationInterpolator configurationInterpolator) {
        this.parentInterpolator = configurationInterpolator;
    }

    public ConfigurationInterpolator getParentInterpolator() {
        return this.parentInterpolator;
    }

    static {
        globalLookups.put(PREFIX_SYSPROPERTIES, StrLookup.systemPropertiesLookup());
        globalLookups.put(PREFIX_CONSTANTS, new ConstantLookup());
        globalLookups.put(PREFIX_ENVIRONMENT, new EnvironmentLookup());
    }
}

