/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.EventSource;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.Reloadable;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public final class ConfigurationUtils {
    static final String PROTOCOL_FILE = "file";
    static final String RESOURCE_PATH_SEPARATOR = "/";
    private static final String FILE_SCHEME = "file:";
    private static final String METHOD_CLONE = "clone";
    private static final int HEX = 16;
    private static final Log LOG = LogFactory.getLog(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream printStream) {
        ConfigurationUtils.dump(configuration, new PrintWriter(printStream));
    }

    public static void dump(Configuration configuration, PrintWriter printWriter) {
        Iterator<String> iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Object object = configuration.getProperty(string);
            printWriter.print(string);
            printWriter.print("=");
            printWriter.print(object);
            if (!iterator.hasNext()) continue;
            printWriter.println();
        }
        printWriter.flush();
    }

    public static String toString(Configuration configuration) {
        StringWriter stringWriter = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void copy(Configuration configuration, Configuration configuration2) {
        Iterator<String> iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            configuration2.setProperty(string, configuration.getProperty(string));
        }
    }

    public static void append(Configuration configuration, Configuration configuration2) {
        Iterator<String> iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            configuration2.addProperty(string, configuration.getProperty(string));
        }
    }

    public static HierarchicalConfiguration convertToHierarchical(Configuration configuration) {
        return ConfigurationUtils.convertToHierarchical(configuration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HierarchicalConfiguration convertToHierarchical(Configuration configuration, ExpressionEngine expressionEngine) {
        if (configuration == null) {
            return null;
        }
        if (configuration instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hierarchicalConfiguration;
            if (configuration instanceof Reloadable) {
                Object object;
                Object object2 = object = ((Reloadable)((Object)configuration)).getReloadLock();
                synchronized (object2) {
                    hierarchicalConfiguration = new HierarchicalConfiguration((HierarchicalConfiguration)configuration);
                }
            } else {
                hierarchicalConfiguration = (HierarchicalConfiguration)configuration;
            }
            if (expressionEngine != null) {
                hierarchicalConfiguration.setExpressionEngine(expressionEngine);
            }
            return hierarchicalConfiguration;
        }
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
        if (expressionEngine != null) {
            hierarchicalConfiguration.setExpressionEngine(expressionEngine);
        }
        boolean bl = hierarchicalConfiguration.isDelimiterParsingDisabled();
        hierarchicalConfiguration.setDelimiterParsingDisabled(true);
        hierarchicalConfiguration.append(configuration);
        hierarchicalConfiguration.setDelimiterParsingDisabled(bl);
        return hierarchicalConfiguration;
    }

    public static Configuration cloneConfiguration(Configuration configuration) throws ConfigurationRuntimeException {
        if (configuration == null) {
            return null;
        }
        try {
            return (Configuration)ConfigurationUtils.clone(configuration);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException(cloneNotSupportedException);
        }
    }

    static Object clone(Object object) throws CloneNotSupportedException {
        if (object instanceof Cloneable) {
            try {
                Method method = object.getClass().getMethod(METHOD_CLONE, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new CloneNotSupportedException("No clone() method found for class" + object.getClass().getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ConfigurationRuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ConfigurationRuntimeException(invocationTargetException);
            }
        }
        throw new CloneNotSupportedException(object.getClass().getName() + " does not implement Cloneable");
    }

    public static URL getURL(String string, String string2) throws MalformedURLException {
        return FileSystem.getDefaultFileSystem().getURL(string, string2);
    }

    static File constructFile(String string, String string2) {
        File file;
        File file2 = null;
        if (string2 != null) {
            file2 = new File(string2);
        }
        if (StringUtils.isEmpty(string) || file2 != null && file2.isAbsolute()) {
            file = new File(string2);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            if (!string.endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
            if (string2.startsWith("." + File.separator)) {
                stringBuilder.append(string2.substring(2));
            } else {
                stringBuilder.append(string2);
            }
            file = new File(stringBuilder.toString());
        }
        return file;
    }

    public static URL locate(String string) {
        return ConfigurationUtils.locate(null, string);
    }

    public static URL locate(String string, String string2) {
        return ConfigurationUtils.locate(FileSystem.getDefaultFileSystem(), string, string2);
    }

    public static URL locate(FileSystem fileSystem, String string, String string2) {
        File file;
        Serializable serializable;
        if (LOG.isDebugEnabled()) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("ConfigurationUtils.locate(): base is ").append(string);
            ((StringBuilder)serializable).append(", name is ").append(string2);
            LOG.debug(((StringBuilder)serializable).toString());
        }
        if (string2 == null) {
            return null;
        }
        serializable = fileSystem.locateFromURL(string, string2);
        if (serializable == null && (file = new File(string2)).isAbsolute() && file.exists()) {
            try {
                serializable = ConfigurationUtils.toURL(file);
                LOG.debug("Loading configuration from the absolute path " + string2);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn("Could not obtain URL from file", malformedURLException);
            }
        }
        if (serializable == null) {
            try {
                file = ConfigurationUtils.constructFile(string, string2);
                if (file != null && file.exists()) {
                    serializable = ConfigurationUtils.toURL(file);
                }
                if (serializable != null) {
                    LOG.debug("Loading configuration from the path " + file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn("Could not obtain URL from file", malformedURLException);
            }
        }
        if (serializable == null) {
            try {
                file = ConfigurationUtils.constructFile(System.getProperty("user.home"), string2);
                if (file != null && file.exists()) {
                    serializable = ConfigurationUtils.toURL(file);
                }
                if (serializable != null) {
                    LOG.debug("Loading configuration from the home path " + file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn("Could not obtain URL from file", malformedURLException);
            }
        }
        if (serializable == null) {
            serializable = ConfigurationUtils.locateFromClasspath(string2);
        }
        return serializable;
    }

    static URL locateFromClasspath(String string) {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (uRL = classLoader.getResource(string)) != null) {
            LOG.debug("Loading configuration from the context classpath (" + string + ")");
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(string)) != null) {
            LOG.debug("Loading configuration from the system classpath (" + string + ")");
        }
        return uRL;
    }

    static String getBasePath(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        if (string.startsWith(FILE_SCHEME) && !string.startsWith("file://")) {
            string = "file://" + string.substring(FILE_SCHEME.length());
        }
        if (string.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(uRL.getPath())) {
            return string;
        }
        return string.substring(0, string.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    static String getFileName(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getPath();
        if (string.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(string)) {
            return null;
        }
        return string.substring(string.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    public static File getFile(String string, String string2) {
        URL uRL;
        File file = new File(string2);
        if (file.isAbsolute()) {
            return file;
        }
        try {
            uRL = new URL(new URL(string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                uRL = null;
            }
        }
        if (uRL != null) {
            return ConfigurationUtils.fileFromURL(uRL);
        }
        return ConfigurationUtils.constructFile(string, string2);
    }

    public static File fileFromURL(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals(PROTOCOL_FILE)) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        int n = 0;
        while ((n = string.indexOf(37, n)) >= 0) {
            if (n + 2 >= string.length()) continue;
            String string2 = string.substring(n + 1, n + 3);
            char c2 = (char)Integer.parseInt(string2, 16);
            string = string.substring(0, n) + c2 + string.substring(n + 3);
        }
        return new File(string);
    }

    static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static void enableRuntimeExceptions(Configuration configuration) {
        if (!(configuration instanceof EventSource)) {
            throw new IllegalArgumentException("Configuration must be derived from EventSource!");
        }
        ((EventSource)((Object)configuration)).addErrorListener(new ConfigurationErrorListener(){

            public void configurationError(ConfigurationErrorEvent configurationErrorEvent) {
                throw new ConfigurationRuntimeException(configurationErrorEvent.getCause());
            }
        });
    }
}

