/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DefaultDataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DisabledDataSourceMonitorRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceMonitorRegistryServiceProvider
implements Provider<DataSourceMonitorRegistryService> {
    private static final int DEFAULT_LIMIT_SIZE = 20;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean traceAgentDataSource;
    private final int dataSourceTraceLimitSize;

    @Inject
    public DataSourceMonitorRegistryServiceProvider(ProfilerConfig profilerConfig) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        this.traceAgentDataSource = profilerConfig.isTraceAgentDataSource();
        this.dataSourceTraceLimitSize = profilerConfig.getDataSourceTraceLimitSize();
    }

    public DataSourceMonitorRegistryService get() {
        if (!this.traceAgentDataSource) {
            return new DisabledDataSourceMonitorRegistryService();
        }
        if (this.dataSourceTraceLimitSize <= 0) {
            this.logger.info("dataSourceTraceLimitSize must greater than 0. It will be set default size {}", (Object)20);
            return new DefaultDataSourceMonitorRegistryService(20);
        }
        return new DefaultDataSourceMonitorRegistryService(this.dataSourceTraceLimitSize);
    }
}

