/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.util.FixedByteArrayOutputStream;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class HttpClient3EntityExtractor
implements EntityExtractor<HttpMethod> {
    private static final int MAX_READ_SIZE = 1024;
    public static final EntityExtractor<HttpMethod> INSTANCE = new HttpClient3EntityExtractor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public String getEntity(HttpMethod httpMethod) {
        block4: {
            EntityEnclosingMethod entityEnclosingMethod;
            RequestEntity entity;
            if (httpMethod instanceof EntityEnclosingMethod && (entity = (entityEnclosingMethod = (EntityEnclosingMethod)httpMethod).getRequestEntity()) != null && entity.isRepeatable() && entity.getContentLength() > 0L) {
                try {
                    String charSet = entityEnclosingMethod.getRequestCharSet();
                    if (StringUtils.isEmpty((String)charSet)) {
                        charSet = "ISO-8859-1";
                    }
                    String entityValue = entity instanceof ByteArrayRequestEntity || entity instanceof StringRequestEntity ? HttpClient3EntityExtractor.entityUtilsToString(entity, charSet) : entity.getClass() + " (ContentType:" + entity.getContentType() + ")";
                    return entityValue;
                }
                catch (Exception e) {
                    if (!this.isDebug) break block4;
                    this.logger.debug("Failed to get entity. httpMethod={}", (Object)httpMethod, (Object)e);
                }
            }
        }
        return null;
    }

    private static String entityUtilsToString(RequestEntity entity, String charSet) throws Exception {
        FixedByteArrayOutputStream outStream = new FixedByteArrayOutputStream(1024);
        entity.writeRequest((OutputStream)outStream);
        String entityValue = outStream.toString(charSet);
        if (entity.getContentLength() > 1024L) {
            StringBuilder sb = new StringBuilder();
            sb.append(entityValue);
            sb.append(" (HTTP entity is large. length: ");
            sb.append(entity.getContentLength());
            sb.append(" )");
            return sb.toString();
        }
        return entityValue;
    }
}

