/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.logging;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.SqlModule;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class Slf4jPLoggerAdapter
implements PLogger {
    public static final int BUFFER_SIZE = 512;
    private static Object EXIST = new Object();
    private static final Map<Class<?>, Object> SIMPLE_TYPE = Slf4jPLoggerAdapter.prepare();
    private final Logger logger;

    private static Map<Class<?>, Object> prepare() {
        IdentityHashMap map = new IdentityHashMap(64);
        Slf4jPLoggerAdapter.put(map, String.class);
        Slf4jPLoggerAdapter.put(map, Boolean.class);
        Slf4jPLoggerAdapter.put(map, Boolean.TYPE);
        Slf4jPLoggerAdapter.put(map, Byte.class);
        Slf4jPLoggerAdapter.put(map, Byte.TYPE);
        Slf4jPLoggerAdapter.put(map, Short.class);
        Slf4jPLoggerAdapter.put(map, Short.TYPE);
        Slf4jPLoggerAdapter.put(map, Integer.class);
        Slf4jPLoggerAdapter.put(map, Integer.TYPE);
        Slf4jPLoggerAdapter.put(map, Long.class);
        Slf4jPLoggerAdapter.put(map, Long.TYPE);
        Slf4jPLoggerAdapter.put(map, Float.class);
        Slf4jPLoggerAdapter.put(map, Float.TYPE);
        Slf4jPLoggerAdapter.put(map, Double.class);
        Slf4jPLoggerAdapter.put(map, Double.TYPE);
        Slf4jPLoggerAdapter.put(map, Character.class);
        Slf4jPLoggerAdapter.put(map, Character.TYPE);
        Slf4jPLoggerAdapter.put(map, BigDecimal.class);
        Slf4jPLoggerAdapter.put(map, StringBuffer.class);
        Slf4jPLoggerAdapter.put(map, BigInteger.class);
        Slf4jPLoggerAdapter.put(map, Date.class);
        Slf4jPLoggerAdapter.put(map, Class.class);
        Slf4jPLoggerAdapter.put(map, Calendar.class);
        Slf4jPLoggerAdapter.put(map, GregorianCalendar.class);
        Slf4jPLoggerAdapter.put(map, URL.class);
        Slf4jPLoggerAdapter.put(map, Object.class);
        if (SqlModule.isSqlModuleEnable()) {
            Slf4jPLoggerAdapter.addSqlModuleSupport(map);
        }
        return map;
    }

    private static void addSqlModuleSupport(Map<Class<?>, Object> map) {
        Slf4jPLoggerAdapter.put(map, SqlModule.getSqlDate());
        Slf4jPLoggerAdapter.put(map, SqlModule.getSqlTime());
        Slf4jPLoggerAdapter.put(map, SqlModule.getSqlTimestamp());
    }

    private static void put(Map<Class<?>, Object> map, Class<?> key) {
        map.put(key, EXIST);
    }

    public Slf4jPLoggerAdapter(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger must not be null");
        }
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public void beforeInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("BEFORE ");
        Slf4jPLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        this.logger.debug(sb.toString());
    }

    public void beforeInterceptor(Object target, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("BEFORE ");
        Slf4jPLoggerAdapter.logMethod(sb, target, args);
        this.logger.debug(sb.toString());
    }

    public void afterInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        Slf4jPLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        Slf4jPLoggerAdapter.logResult(sb, result, throwable);
        if (throwable == null) {
            this.logger.debug(sb.toString());
        } else {
            this.logger.debug(sb.toString(), throwable);
        }
    }

    public void afterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        Slf4jPLoggerAdapter.logMethod(sb, target, args);
        Slf4jPLoggerAdapter.logResult(sb, result, throwable);
        if (throwable == null) {
            this.logger.debug(sb.toString());
        } else {
            this.logger.debug(sb.toString(), throwable);
        }
    }

    private static void logResult(StringBuilder sb, Object result, Throwable throwable) {
        if (throwable == null) {
            sb.append(" result:");
            sb.append(Slf4jPLoggerAdapter.normalizedParameter(result));
        } else {
            sb.append(" Caused:");
            sb.append(throwable.getMessage());
        }
    }

    public void afterInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        Slf4jPLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        this.logger.debug(sb.toString());
    }

    public void afterInterceptor(Object target, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        Slf4jPLoggerAdapter.logMethod(sb, target, args);
        this.logger.debug(sb.toString());
    }

    private static void logMethod(StringBuilder sb, Object target, String className, String methodName, String parameterDescription, Object[] args) {
        sb.append(Slf4jPLoggerAdapter.getTarget(target));
        sb.append(' ');
        sb.append(className);
        sb.append(' ');
        sb.append(methodName);
        sb.append(parameterDescription);
        sb.append(" args:");
        Slf4jPLoggerAdapter.appendParameterList(sb, args);
    }

    private static void logMethod(StringBuilder sb, Object target, Object[] args) {
        sb.append(Slf4jPLoggerAdapter.getTarget(target));
        sb.append(' ');
        sb.append(" args:");
        Slf4jPLoggerAdapter.appendParameterList(sb, args);
    }

    private static String getTarget(Object target) {
        if (target == null) {
            return "target=null";
        }
        return target.getClass().getName();
    }

    private static void appendParameterList(StringBuilder sb, Object[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            sb.append("()");
            return;
        }
        if (args.length > 0) {
            sb.append('(');
            sb.append(Slf4jPLoggerAdapter.normalizedParameter(args[0]));
            for (int i = 1; i < args.length; ++i) {
                sb.append(", ");
                sb.append(Slf4jPLoggerAdapter.normalizedParameter(args[i]));
            }
            sb.append(')');
        }
    }

    private static String normalizedParameter(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (Slf4jPLoggerAdapter.isSimpleType(arg)) {
            return arg.toString();
        }
        return Slf4jPLoggerAdapter.getSimpleName(arg.getClass());
    }

    static boolean isSimpleType(Object arg) {
        Object find = SIMPLE_TYPE.get(arg.getClass());
        return find != null;
    }

    static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return Slf4jPLoggerAdapter.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String simpleName = clazz.getName();
        if (simpleName == null) {
            return "";
        }
        int lastPackagePosition = simpleName.lastIndexOf(46);
        if (lastPackagePosition != -1) {
            return simpleName.substring(lastPackagePosition + 1);
        }
        return simpleName;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.logger.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.logger.trace(format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.logger.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.logger.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        this.logger.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.logger.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.logger.debug(format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.logger.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.logger.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        this.logger.debug(marker, format, argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.logger.debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        this.logger.info(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.logger.info(format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.logger.info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.logger.info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.logger.info(marker, format, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.logger.info(marker, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn(format, arg);
    }

    public void warn(String format, Object[] argArray) {
        this.logger.warn(format, argArray);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.logger.warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.logger.warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.logger.warn(marker, format, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.logger.warn(marker, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        this.logger.error(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.logger.error(format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.logger.error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.logger.error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.logger.error(marker, format, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.logger.error(marker, msg, t);
    }
}

