/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.weblogic.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.weblogic.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.weblogic.WeblogicConfiguration;
import com.navercorp.pinpoint.plugin.weblogic.WeblogicConstants;
import com.navercorp.pinpoint.plugin.weblogic.interceptor.ServletRequestImplAdaptor;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;

public class WebAppServletContextExecuteInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private MethodDescriptor methodDescriptor;
    private ServletRequestListenerInterceptorHelper<ServletRequestImpl> servletRequestListenerInterceptorHelper;

    public WebAppServletContextExecuteInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
        WeblogicConfiguration config = new WeblogicConfiguration(traceContext.getProfilerConfig());
        ServletRequestImplAdaptor requestAdaptor = new ServletRequestImplAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<ServletRequestImpl> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(WeblogicConstants.WEBLOGIC, traceContext, (RequestAdaptor)requestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
    }

    public void before(Object target, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (!this.validate(args)) {
                return;
            }
            try {
                ServletRequestImpl request = (ServletRequestImpl)args[0];
                this.servletRequestListenerInterceptorHelper.initialized((Object)request, WeblogicConstants.WEBLOGIC_METHOD, this.methodDescriptor);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block4;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.validate(args)) {
            return;
        }
        try {
            ServletRequestImpl request = (ServletRequestImpl)args[0];
            ServletResponseImpl response = (ServletResponseImpl)args[1];
            int statusCode = this.getStatusCode(response);
            this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
        }
        catch (Throwable t) {
            this.logger.info("Failed to servlet request event handle.", t);
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 2) {
            return false;
        }
        if (!(args[0] instanceof ServletRequestImpl)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object, Not implemented of weblogic.servlet.internal.ServletRequestImpl. args[0]={}", args[0]);
            }
            return false;
        }
        if (!(args[1] instanceof ServletResponseImpl)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[1] object, Not implemented of weblogic.servlet.internal.ServletResponseImpl. args[1]={}.", args[1]);
            }
            return false;
        }
        return true;
    }

    private int getStatusCode(ServletResponseImpl response) {
        try {
            return response.getStatus();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

