/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent.monitor;

import com.secnium.iast.agent.IastProperties;
import com.secnium.iast.agent.manager.EngineManager;
import com.secnium.iast.agent.monitor.EngineMonitor;
import com.secnium.iast.agent.monitor.IMonitor;
import com.secnium.iast.agent.monitor.PerformanceMonitor;
import java.util.ArrayList;

public class MonitorDaemonThread
implements Runnable {
    public ArrayList<IMonitor> monitorTasks;
    private final EngineManager engineManager;
    private final IastProperties properties = IastProperties.getInstance();

    public MonitorDaemonThread(EngineManager engineManager) {
        this.monitorTasks = new ArrayList();
        this.monitorTasks.add(new PerformanceMonitor(engineManager));
        this.monitorTasks.add(new EngineMonitor(engineManager));
        this.engineManager = engineManager;
    }

    @Override
    public void run() {
        if (this.startEngine()) {
            while (true) {
                for (IMonitor monitor : this.monitorTasks) {
                    monitor.check();
                }
                this.threadSleep();
            }
        }
    }

    private boolean startEngine() {
        boolean status;
        int timeInterval = this.properties.getDelayTime();
        if (timeInterval > 0) {
            try {
                System.out.println("\u5f00\u542f\u5ef6\u65f6\u52a0\u8f7d\u6a21\u5f0f\uff0c\u68c0\u6d4b\u5f15\u64ce\u5c06\u5728" + timeInterval + "s\u540e\u542f\u52a8");
                Thread.sleep(timeInterval * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        status = (status = this.engineManager.downloadEnginePackage()) && this.engineManager.install();
        status = status && this.engineManager.start();
        System.out.println("\u5f15\u64ce\u542f\u52a8\u6210\u529f\uff0c\u6f0f\u6d1e\u68c0\u6d4b\u529f\u80fd\u5f00\u542f");
        return status;
    }

    private void threadSleep() {
        try {
            long milliseconds = 60000L;
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

