/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.service.DefaultTraceMetadataLoaderService;
import com.navercorp.pinpoint.common.service.TraceMetadataLoaderService;
import com.navercorp.pinpoint.common.trace.TraceMetadataProvider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.logger.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class TraceMetadataLoaderServiceProvider
implements Provider<TraceMetadataLoaderService> {
    private final PluginLoader pluginLoader;
    private final CommonLoggerFactory commonLoggerFactory;

    @Inject
    public TraceMetadataLoaderServiceProvider(CommonLoggerFactory commonLoggerFactory, PluginLoader pluginLoader) {
        this.commonLoggerFactory = (CommonLoggerFactory)Assert.requireNonNull((Object)commonLoggerFactory, (String)"commonLogger must not be null");
        this.pluginLoader = (PluginLoader)Assert.requireNonNull((Object)pluginLoader, (String)"pluginLoader must not be null");
    }

    public TraceMetadataLoaderService get() {
        List plugins = this.pluginLoader.load(TraceMetadataProvider.class);
        ArrayList providers = new ArrayList();
        for (Plugin plugin : plugins) {
            List pluginList = plugin.getInstanceList();
            providers.addAll(pluginList);
        }
        DefaultTraceMetadataLoaderService typeLoaderService = new DefaultTraceMetadataLoaderService(providers, this.commonLoggerFactory);
        return typeLoaderService;
    }
}

