/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.buffer;

import com.navercorp.pinpoint.rpc.buffer.ByteBufferFactory;
import com.navercorp.pinpoint.rpc.buffer.ByteBufferType;
import com.navercorp.pinpoint.rpc.buffer.DirectByteBufferFactory;
import com.navercorp.pinpoint.rpc.buffer.HeapByteBufferFactory;
import java.util.EnumMap;
import java.util.Map;

public final class ByteBufferFactoryLocator {
    private static final Map<ByteBufferType, ByteBufferFactory> FACTORY_REPOSITORY = new EnumMap<ByteBufferType, ByteBufferFactory>(ByteBufferType.class);

    public static ByteBufferFactory getFactory(String name) {
        ByteBufferType byteBufferType = ByteBufferType.getValue(name);
        if (byteBufferType == null) {
            throw new IllegalArgumentException("Unknown ByteBufferType:" + name);
        }
        return ByteBufferFactoryLocator.getFactory(byteBufferType);
    }

    public static ByteBufferFactory getFactory(ByteBufferType byteBufferType) {
        return FACTORY_REPOSITORY.get((Object)byteBufferType);
    }

    static {
        FACTORY_REPOSITORY.put(ByteBufferType.DIRECT, new DirectByteBufferFactory());
        FACTORY_REPOSITORY.put(ByteBufferType.HEAP, new HeapByteBufferFactory());
    }
}

