/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.processors.UpdateResult;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UpdateProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("UpdateProcessor");
    public static final String FAILED_NEXT = "failed-next";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ProcessContext context) throws ProcessException {
        File agentDir = (File)context.get("Agent-Directory");
        if (agentDir == null) {
            this.logger.warn("No agent directory");
            return FAILED_NEXT;
        }
        File updateZipFile = (File)context.get("update_file");
        if (updateZipFile == null) {
            this.logger.warn("No upgrade package");
            return FAILED_NEXT;
        }
        File agentUpdateDir = (File)context.get("Agent-Update-Directory");
        if (agentUpdateDir == null || !agentUpdateDir.exists()) {
            this.logger.info("No directory for updates");
            return FAILED_NEXT;
        }
        boolean contatins_core = false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(updateZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                if (!zipEntryName.endsWith("tapm-agent-core.jar")) continue;
                contatins_core = true;
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("Read Tapm agent core failed", e);
            context.put("context_update_result", UpdateResult.failed(6, "Error reading core file process"));
            String entry = FAILED_NEXT;
            return entry;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception zipEntryName) {}
            }
            this.removeUpdateInfoFile(context);
        }
        if (!contatins_core) {
            this.logger.error("No core file in {}", updateZipFile.getAbsolutePath());
            context.put("context_update_result", UpdateResult.failed(6, "No core files"));
            return FAILED_NEXT;
        }
        File extensionsDir = new File(agentDir, "extensions");
        File agentFile = new File(agentDir, "tapm-agent-core.jar");
        List<String> xmlExts = null;
        try {
            xmlExts = this.clearExtensionDir(extensionsDir);
            if (!xmlExts.isEmpty()) {
                this.logger.info("These files in the extensions directory will be retained, {}", xmlExts);
            }
            if (agentFile.exists()) {
                agentFile.delete();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in deleting old version files", e);
            return "failed";
        }
        zipFile = null;
        try {
            zipFile = new ZipFile(updateZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String pluginFileName;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = null;
                File destFile = null;
                if (zipEntryName.endsWith("tapm-agent-core.jar")) {
                    in = zipFile.getInputStream(entry);
                    destFile = agentFile;
                } else if (zipEntryName.contains("/extensions/") && (pluginFileName = zipEntryName.substring(zipEntryName.indexOf("/extensions/") + 12)).length() > 0) {
                    if (xmlExts.contains(pluginFileName)) {
                        this.logger.info("This file({}) will not be upgraded", pluginFileName);
                        continue;
                    }
                    in = zipFile.getInputStream(entry);
                    destFile = new File(extensionsDir, pluginFileName);
                }
                if (in == null || destFile == null) continue;
                try {
                    Files.fileCopy(in, destFile);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Update Tapm agent failed", e);
            String string = "failed";
            return string;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        this.logger.info("Update Tapm agent version to {}", context.get("update_version"));
        return "next";
    }

    private List<String> clearExtensionDir(File extensionsDir) throws IOException {
        File[] files;
        ArrayList<String> xmlFiles = new ArrayList<String>();
        if (!extensionsDir.exists()) {
            extensionsDir.mkdirs();
            return xmlFiles;
        }
        if (!extensionsDir.isDirectory()) {
            if (!extensionsDir.delete()) {
                throw new IOException("The \"extensions\" are not directories and cannot be deleted");
            }
            extensionsDir.mkdirs();
            return xmlFiles;
        }
        for (File file : files = extensionsDir.listFiles()) {
            String fn = file.getName();
            if (fn.endsWith(".xml")) {
                xmlFiles.add(fn);
                continue;
            }
            if (!file.isFile()) continue;
            file.delete();
        }
        return xmlFiles;
    }

    private void removeUpdateInfoFile(ProcessContext context) {
        try {
            File updateFile = (File)context.get("update_info_file");
            if (updateFile != null && updateFile.exists()) {
                updateFile.delete();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error in deleting update info files ", e);
        }
    }
}

