/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarFile;

public class IastClassLoader
extends URLClassLoader {
    private final String toString;
    private final String path;

    public IastClassLoader(String namespace, String jarFilePath) throws MalformedURLException {
        super(new URL[]{new URL("file:" + jarFilePath)});
        this.path = jarFilePath;
        this.toString = String.format("IastClassLoader[namespace=%s;path=%s;]", namespace, this.path);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (null != url) {
            return url;
        }
        url = super.getResource(name);
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = this.findResources(name);
        if (null != urls) {
            return urls;
        }
        urls = super.getResources(name);
        return urls;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        try {
            Class<?> aClass = this.findClass(name);
            if (resolve) {
                this.resolveClass(aClass);
            }
            return aClass;
        }
        catch (Exception e) {
            return super.loadClass(name, resolve);
        }
    }

    public String toString() {
        return this.toString;
    }

    public void closeIfPossible() {
        if (this instanceof Closeable) {
            try {
                ((Closeable)this).close();
            }
            catch (Throwable cause) {
                // empty catch block
            }
            return;
        }
        try {
            Object sun_misc_URLClassPath = this.forceGetDeclaredFieldValue(URLClassLoader.class, "ucp", this);
            Object java_util_Collection = this.forceGetDeclaredFieldValue(sun_misc_URLClassPath.getClass(), "loaders", sun_misc_URLClassPath);
            for (Object sun_misc_URLClassPath_JarLoader : ((Collection)java_util_Collection).toArray()) {
                try {
                    JarFile java_util_jar_JarFile = (JarFile)this.forceGetDeclaredFieldValue(sun_misc_URLClassPath_JarLoader.getClass(), "jar", sun_misc_URLClassPath_JarLoader);
                    java_util_jar_JarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private <T> T forceGetDeclaredFieldValue(Class<?> clazz, String name, Object target) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return (T)field.get(target);
    }
}

