/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import com.secnium.iast.agent.AgentRegister;
import com.secnium.iast.agent.IastProperties;
import java.io.BufferedInputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class UpdateUtils {
    private static final IastProperties PROPERTIES = IastProperties.getInstance();
    private static final String UPDATE_URL = PROPERTIES.getBaseUrl() + "/api/v1/engine/update";
    private static final String START_URL = PROPERTIES.getBaseUrl() + "/api/v1/engine/startstop";
    private static final String AGENT_TOKEN = URLEncoder.encode(AgentRegister.getAgentToken());
    public static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };

    public static boolean needUpdate() {
        String respRaw = UpdateUtils.sendRequest(UPDATE_URL + "?agent_name=" + AGENT_TOKEN);
        if (respRaw != null && !respRaw.isEmpty()) {
            JSONObject resp = new JSONObject(respRaw);
            return "1".equals(resp.get("data").toString());
        }
        return false;
    }

    public static String checkForStatus() {
        try {
            String respRaw = UpdateUtils.sendRequest(START_URL + "?agent_name=" + AGENT_TOKEN);
            if (respRaw != null && !respRaw.isEmpty()) {
                JSONObject resp = new JSONObject(respRaw);
                return resp.get("data").toString();
            }
        }
        catch (Exception e) {
            return "other";
        }
        return "other";
    }

    public static void setUpdateSuccess() {
        UpdateUtils.sendRequest(UPDATE_URL + "/0?agent_name=" + AGENT_TOKEN);
    }

    public static void setUpdateFailure() {
        UpdateUtils.sendRequest(UPDATE_URL + "/1?agent_name=" + AGENT_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendRequest(String urlStr) {
        HttpURLConnection connection = null;
        try {
            int bytesRead;
            UpdateUtils.trustAllHosts();
            URL url = new URL(urlStr);
            Proxy proxy = UpdateUtils.loadProxy();
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                HttpsURLConnection https = proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy);
                https.setHostnameVerifier(DO_NOT_VERIFY);
                connection = https;
            } else {
                connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            }
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "SecniumIast Java Agent");
            connection.setRequestProperty("Authorization", "Token " + PROPERTIES.getIastServerToken());
            connection.setRequestProperty("Accept", "*/*");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            byte[] dataBuffer = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                sb.append(new String(dataBuffer, 0, bytesRead));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Proxy loadProxy() {
        try {
            if (PROPERTIES.isProxyEnable()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROPERTIES.getProxyHost(), PROPERTIES.getProxyPort()));
                return proxy;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

