/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.PipelineFactory;
import com.navercorp.pinpoint.rpc.client.ClientHandlerFactory;
import com.navercorp.pinpoint.rpc.client.ConnectFuture;
import com.navercorp.pinpoint.rpc.client.ConnectionFactory;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.SocketOption;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class Connection {
    private final ConnectionFactory connectionFactory;
    private final SocketOption socketOption;
    private final ChannelFactory channelFactory;
    private final ClientHandlerFactory clientHandlerFactory;
    private PinpointClientHandler pinpointClientHandler;
    private ChannelFuture connectFuture;

    public Connection(ConnectionFactory connectionFactory, SocketOption socketOption, ChannelFactory channelFactory, ClientHandlerFactory clientHandlerFactory) {
        this.connectionFactory = (ConnectionFactory)Assert.requireNonNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.socketOption = (SocketOption)Assert.requireNonNull((Object)socketOption, (String)"socketOption must not be null");
        this.channelFactory = (ChannelFactory)Assert.requireNonNull((Object)channelFactory, (String)"channelFactory must not be null");
        this.clientHandlerFactory = (ClientHandlerFactory)Assert.requireNonNull((Object)clientHandlerFactory, (String)"clientHandlerFactory must not be null");
    }

    void connect(SocketAddressProvider remoteAddressProvider, boolean reconnect, PipelineFactory pipelineFactory) {
        Assert.requireNonNull((Object)remoteAddressProvider, (String)"remoteAddress must not be null");
        ChannelPipeline pipeline = pipelineFactory.newPipeline();
        Timer channelTimer = Connection.createTimer("Pinpoint-PinpointClientHandler-Timer");
        WriteTimeoutHandler writeTimeout = new WriteTimeoutHandler(channelTimer, 3000L, TimeUnit.MILLISECONDS);
        pipeline.addLast("writeTimeout", (ChannelHandler)writeTimeout);
        this.pinpointClientHandler = this.clientHandlerFactory.newClientHandler(this.connectionFactory, remoteAddressProvider, channelTimer, reconnect);
        if (!(this.pinpointClientHandler instanceof SimpleChannelHandler)) {
            throw new IllegalArgumentException("invalid pinpointClientHandler");
        }
        pipeline.addLast("socketHandler", (ChannelHandler)((SimpleChannelHandler)this.pinpointClientHandler));
        InetSocketAddress remoteAddress = remoteAddressProvider.resolve();
        this.connectFuture = this.connect0(remoteAddress, pipeline);
    }

    private ChannelFuture connect0(SocketAddress remoteAddress, ChannelPipeline pipeline) {
        Channel channel = this.newChannel(pipeline);
        return channel.connect(remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel newChannel(ChannelPipeline pipeline) {
        Channel ch = this.channelFactory.newChannel(pipeline);
        boolean success = false;
        try {
            ch.getConfig().setOptions(this.socketOption.toMap());
            success = true;
        }
        finally {
            if (!success) {
                ch.close();
            }
        }
        return ch;
    }

    public ChannelFuture getConnectFuture() {
        return this.connectFuture;
    }

    public PinpointClientHandler getPinpointClientHandler() {
        return this.pinpointClientHandler;
    }

    private static Timer createTimer(String timerName) {
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer(timerName, 100L, TimeUnit.MILLISECONDS, 512);
        timer.start();
        return timer;
    }

    private PinpointClientHandler awaitConnected0() {
        ConnectFuture handlerConnectFuture = this.pinpointClientHandler.getConnectFuture();
        handlerConnectFuture.awaitUninterruptibly();
        if (ConnectFuture.Result.FAIL == handlerConnectFuture.getResult()) {
            SocketAddress remoteAddress = this.connectFuture.getChannel().getRemoteAddress();
            throw new PinpointSocketException("connect fail to " + remoteAddress + ".", this.connectFuture.getCause());
        }
        return this.pinpointClientHandler;
    }

    public PinpointClient awaitConnected() {
        PinpointClientHandler pinpointClientHandler = this.awaitConnected0();
        DefaultPinpointClient pinpointClient = new DefaultPinpointClient(pinpointClientHandler);
        return pinpointClient;
    }
}

