/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.jboss.JbossConstants;

public class ContextInvocationInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor methodDescriptor;
    private final TraceContext traceContext;

    public ContextInvocationInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        block5: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                Trace trace = this.traceContext.currentTraceObject();
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(JbossConstants.JBOSS_METHOD);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

