/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.async;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpringAsyncConfig {
    private static final String[] DEFAULT_ASYNC_TASK_EXECUTOR = new String[]{"org.springframework.scheduling.concurrent.ConcurrentTaskExecutor", "org.springframework.core.task.SimpleAsyncTaskExecutor", "org.springframework.scheduling.quartz.SimpleThreadPoolTaskExecutor", "org.springframework.core.task.support.TaskExecutorAdapter", "org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor", "org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler", "org.springframework.jca.work.WorkManagerTaskExecutor", "org.springframework.scheduling.commonj.WorkManagerTaskExecutor"};
    private final List<String> asyncTaskExecutorClassNameList = new ArrayList<String>(Arrays.asList(DEFAULT_ASYNC_TASK_EXECUTOR));
    private final boolean enable;

    public SpringAsyncConfig(ProfilerConfig config) {
        this.enable = config.readBoolean("profiler.spring.async.enable", true);
        List list = config.readList("profiler.spring.async.executor.class.names");
        if (!list.isEmpty()) {
            for (String className : list) {
                if (this.asyncTaskExecutorClassNameList.contains(className)) continue;
                this.asyncTaskExecutorClassNameList.add(className);
            }
        }
    }

    public List<String> getAsyncTaskExecutorClassNameList() {
        return this.asyncTaskExecutorClassNameList;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SpringAsyncConfig{");
        sb.append("asyncTaskExecutorClassNameList=").append(this.asyncTaskExecutorClassNameList);
        sb.append(", enable=").append(this.enable);
        sb.append('}');
        return sb.toString();
    }
}

