/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.cpu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.JvmType;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuLoadMetricProvider
implements Provider<CpuLoadMetric> {
    private static final String ORACLE_JDK6_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.oracle.Java6CpuLoadMetric";
    private static final String ORACLE_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.oracle.DefaultCpuLoadMetric";
    private static final String IBM_JDK6_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.ibm.Java6CpuLoadMetric";
    private static final String IBM_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.ibm.DefaultCpuLoadMetric";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String vendorName;

    @Inject
    public CpuLoadMetricProvider(ProfilerConfig profilerConfig) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        this.vendorName = profilerConfig.getProfilerJvmVendorName();
    }

    public CpuLoadMetric get() {
        JvmType jvmType = JvmType.fromVendor((String)this.vendorName);
        if (jvmType == JvmType.UNKNOWN) {
            jvmType = JvmUtils.getType();
        }
        String classToLoad = this.getCpuLoadMetricClassName(jvmType);
        CpuLoadMetric cpuLoadMetric = this.createCpuLoadMetric(classToLoad);
        this.logger.info("loaded : {}", (Object)cpuLoadMetric);
        return cpuLoadMetric;
    }

    private String getCpuLoadMetricClassName(JvmType jvmType) {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        if (jvmType == JvmType.ORACLE || jvmType == JvmType.OPENJDK) {
            if (jvmVersion.onOrAfter(JvmVersion.JAVA_7)) {
                return ORACLE_CPU_LOAD_METRIC;
            }
            if (jvmVersion.onOrAfter(JvmVersion.JAVA_5)) {
                return ORACLE_JDK6_CPU_LOAD_METRIC;
            }
        }
        if (jvmType == JvmType.IBM) {
            if (jvmVersion.onOrAfter(JvmVersion.JAVA_7)) {
                return IBM_CPU_LOAD_METRIC;
            }
            if (jvmVersion == JvmVersion.JAVA_6) {
                return IBM_JDK6_CPU_LOAD_METRIC;
            }
        }
        return null;
    }

    private CpuLoadMetric createCpuLoadMetric(String classToLoad) {
        if (classToLoad == null) {
            return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
        }
        try {
            Class<?> cpuLoadMetricClass = Class.forName(classToLoad);
            try {
                Constructor<?> cpuLoadMetricConstructor = cpuLoadMetricClass.getConstructor(new Class[0]);
                return (CpuLoadMetric)cpuLoadMetricConstructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("Unknown CpuLoadMetric : {}", (Object)classToLoad);
                return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
            }
        }
        catch (Exception e) {
            this.logger.warn("Error creating CpuLoadMetric [" + classToLoad + "]");
            return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
        }
    }
}

