/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.ning.asynchttpclient;

import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.asynchttpclient.Request;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;

public class NingEntityExtractorV2
implements EntityExtractor<Request> {
    public static final EntityExtractor<Request> INSTANCE = new NingEntityExtractorV2();
    private static final int MAX_READ_SIZE = 1024;

    public String getEntity(Request httpRequest) {
        String stringData = httpRequest.getStringData();
        if (stringData != null) {
            return stringData;
        }
        byte[] byteData = httpRequest.getByteData();
        if (byteData != null) {
            return "BYTE_DATA";
        }
        InputStream streamData = httpRequest.getStreamData();
        if (streamData != null) {
            return "STREAM_DATA";
        }
        List parts = httpRequest.getBodyParts();
        if (CollectionUtils.hasLength((Collection)parts)) {
            StringBuilder sb = new StringBuilder();
            Iterator iterator = parts.iterator();
            while (iterator.hasNext()) {
                ByteArrayPart p;
                Part part = (Part)iterator.next();
                if (part instanceof ByteArrayPart) {
                    p = (ByteArrayPart)part;
                    sb.append(part.getName());
                    sb.append("=BYTE_ARRAY_");
                    sb.append(p.getBytes().length);
                } else if (part instanceof FilePart) {
                    p = (FilePart)part;
                    sb.append(part.getName());
                    sb.append("=FILE_");
                    sb.append(p.getContentType());
                } else if (part instanceof StringPart) {
                    p = (StringPart)part;
                    sb.append(part.getName());
                    sb.append("=STRING");
                }
                if (sb.length() >= 1024) break;
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        return null;
    }
}

