/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans.interceptor;

import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor1;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.spring.beans.interceptor.AbstractSpringBeanCreationInterceptor;
import com.navercorp.pinpoint.plugin.spring.beans.interceptor.TargetBeanFilter;
import java.lang.reflect.Method;

public class CreateBeanInstanceInterceptor
extends AbstractSpringBeanCreationInterceptor
implements AroundInterceptor1 {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private volatile Method getWrappedInstanceMethod;

    public CreateBeanInstanceInterceptor(Instrumentor instrumentor, TransformCallback transformer, TargetBeanFilter filter) {
        super(instrumentor, transformer, filter);
    }

    public void before(Object target, Object arg0) {
    }

    public void after(Object target, Object beanNameObject, Object result, Throwable throwable) {
        block9: {
            try {
                if (result == null || throwable != null) {
                    return;
                }
                if (!(beanNameObject instanceof String)) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("invalid type:{}", beanNameObject);
                    }
                    return;
                }
                String beanName = (String)beanNameObject;
                try {
                    Method getWrappedInstanceMethod = this.getGetWrappedInstanceMethod(result);
                    if (getWrappedInstanceMethod != null) {
                        Object bean = getWrappedInstanceMethod.invoke(result, new Object[0]);
                        this.processBean(beanName, bean);
                    }
                }
                catch (Exception e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Fail to get create bean instance", (Throwable)e);
                    }
                    return;
                }
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block9;
                this.logger.warn("Unexpected exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getGetWrappedInstanceMethod(Object object) throws NoSuchMethodException {
        if (this.getWrappedInstanceMethod != null) {
            return this.getWrappedInstanceMethod;
        }
        CreateBeanInstanceInterceptor createBeanInstanceInterceptor = this;
        synchronized (createBeanInstanceInterceptor) {
            if (this.getWrappedInstanceMethod != null) {
                return this.getWrappedInstanceMethod;
            }
            Class<?> aClass = object.getClass();
            Method findedMethod = aClass.getMethod("getWrappedInstance", new Class[0]);
            if (findedMethod != null) {
                this.getWrappedInstanceMethod = findedMethod;
                return this.getWrappedInstanceMethod;
            }
        }
        return null;
    }
}

