/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.user.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.user.UserIncludeMethodDescriptor;

public class UserIncludeMethodInterceptor
implements AroundInterceptor {
    private static final String SCOPE_NAME = "##USER_INCLUDE_TRACE";
    private static final UserIncludeMethodDescriptor USER_INCLUDE_METHOD_DESCRIPTOR = new UserIncludeMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public UserIncludeMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
        traceContext.cacheApi((MethodDescriptor)USER_INCLUDE_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            if (this.isDebug) {
                this.logger.debug("Not found trace. Create user include trace.");
            }
            if ((trace = this.createUserIncludeTrace()) == null) {
                return;
            }
        } else if (this.isDebug) {
            this.logger.debug("Found trace {}, sampled={}.", (Object)trace, (Object)trace.canSampled());
        }
        this.entryUserIncludeTraceScope(trace);
        if (!trace.canSampled()) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!this.leaveUserIncludeTraceScope(trace)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Failed to leave scope of user include trace. trace={}, sampled={}", (Object)trace, (Object)trace.canSampled());
            }
            this.deleteUserIncludeTrace(trace);
            return;
        }
        if (!trace.canSampled()) {
            if (this.isUserIncludeTraceDestination(trace)) {
                this.deleteUserIncludeTrace(trace);
            }
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordServiceType(ServiceType.INTERNAL_METHOD);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
            if (this.isUserIncludeTraceDestination(trace)) {
                this.deleteUserIncludeTrace(trace);
            }
        }
    }

    private Trace createUserIncludeTrace() {
        TraceScope oldScope;
        Trace trace = this.traceContext.newTraceObject();
        if (this.isDebug) {
            this.logger.debug("New user include trace {} and sampled {}", (Object)trace, (Object)trace.canSampled());
        }
        if ((oldScope = trace.addScope(SCOPE_NAME)) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Duplicated user include trace scope={}.", (Object)oldScope.getName());
            }
            this.deleteUserIncludeTrace(trace);
            return null;
        }
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(ServiceType.STAND_ALONE);
            recorder.recordApi((MethodDescriptor)USER_INCLUDE_METHOD_DESCRIPTOR);
        }
        return trace;
    }

    private void deleteUserIncludeTrace(Trace trace) {
        if (this.isDebug) {
            this.logger.debug("Delete user include trace={}, sampled={}", (Object)trace, (Object)trace.canSampled());
        }
        this.traceContext.removeTraceObject();
        trace.close();
    }

    private void entryUserIncludeTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        if (scope != null) {
            scope.tryEnter();
            if (this.isDebug) {
                this.logger.debug("Try enter trace scope={}", (Object)scope.getName());
            }
        }
    }

    private boolean leaveUserIncludeTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
                if (this.isDebug) {
                    this.logger.debug("Leave trace scope={}", (Object)scope.getName());
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isUserIncludeTrace(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        return scope != null;
    }

    private boolean isUserIncludeTraceDestination(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        return scope != null && !scope.isActive();
    }
}

