/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapperAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.plugin.vertx.HttpRequestClientHeaderAdaptor;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import com.navercorp.pinpoint.plugin.vertx.VertxCookieExtractor;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpClientConfig;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpClientRequestWrapper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;

public class HttpClientStreamInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;
    private final ClientRequestRecorder<ClientRequestWrapper> clientRequestRecorder;
    private final CookieRecorder<HttpRequest> cookieRecorder;
    private final RequestTraceWriter<HttpRequest> requestTraceWriter;

    public HttpClientStreamInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        VertxHttpClientConfig config = new VertxHttpClientConfig(traceContext.getProfilerConfig());
        ClientRequestAdaptor clientRequestAdaptor = ClientRequestWrapperAdaptor.INSTANCE;
        this.clientRequestRecorder = new ClientRequestRecorder(config.isParam(), clientRequestAdaptor);
        VertxCookieExtractor cookieExtractor = new VertxCookieExtractor();
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)config.getHttpDumpConfig(), (CookieExtractor)cookieExtractor);
        HttpRequestClientHeaderAdaptor clientHeaderAdaptor = new HttpRequestClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        block6: {
            Trace trace;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((trace = this.traceContext.currentTraceObject()) == null) {
                return;
            }
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                if (!this.validate(args)) {
                    return;
                }
                HttpRequest request = (HttpRequest)args[0];
                HttpHeaders headers = request.headers();
                if (headers == null) {
                    return;
                }
                String host = (String)args[1];
                TraceId nextId = trace.getTraceId().getNextTraceId();
                recorder.recordNextSpanId(nextId.getSpanId());
                this.requestTraceWriter.write((Object)request, nextId, host);
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 2) {
            this.logger.debug("Invalid args object. args={}.", args);
            return false;
        }
        if (!(args[0] instanceof HttpRequest)) {
            this.logger.debug("Invalid args[0] object. {}.", args[0]);
            return false;
        }
        if (!(args[1] instanceof String)) {
            this.logger.debug("Invalid args[1] object. {}.", args[1]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            recorder.recordServiceType(VertxConstants.VERTX_HTTP_CLIENT);
            if (!this.validate(args)) {
                return;
            }
            HttpRequest request = (HttpRequest)args[0];
            HttpHeaders headers = request.headers();
            if (headers == null) {
                return;
            }
            String host = (String)args[1];
            VertxHttpClientRequestWrapper clientRequest = new VertxHttpClientRequestWrapper(request, host);
            this.clientRequestRecorder.record(recorder, (Object)clientRequest, throwable);
            this.cookieRecorder.record(recorder, (Object)request, throwable);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

