/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.jetty.JettyConstants;
import java.util.Arrays;
import java.util.List;

public class JettyDetector
implements ApplicationTypeDetector {
    private static final String DEFAULT_BOOTSTRAP_MAIN = "org.eclipse.jetty.start.Main";
    private final List<String> bootstrapMains;

    public JettyDetector(List<String> bootstrapMains) {
        this.bootstrapMains = CollectionUtils.isEmpty(bootstrapMains) ? Arrays.asList(DEFAULT_BOOTSTRAP_MAIN) : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return JettyConstants.JETTY;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains);
    }
}

