/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.pair.NameIntValuePair;
import com.navercorp.pinpoint.plugin.httpclient4.interceptor.AbstractHttpClientExecuteMethodInterceptor;
import java.net.URI;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpClientExecuteMethodWithHttpUriRequestInterceptor
extends AbstractHttpClientExecuteMethodInterceptor {
    private static final int HTTP_URI_REQUEST_INDEX = 0;

    public HttpClientExecuteMethodWithHttpUriRequestInterceptor(boolean isHasCallbackParam, TraceContext context, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        super(HttpClientExecuteMethodWithHttpUriRequestInterceptor.class, isHasCallbackParam, context, methodDescriptor, interceptorScope);
    }

    @Override
    protected NameIntValuePair<String> getHost(Object[] args) {
        HttpUriRequest httpUriRequest = this.getHttpUriRequest(args);
        if (httpUriRequest == null) {
            return null;
        }
        URI uri = httpUriRequest.getURI();
        return this.extractHost(uri);
    }

    @Override
    protected HttpRequest getHttpRequest(Object[] args) {
        return this.getHttpUriRequest(args);
    }

    private HttpUriRequest getHttpUriRequest(Object[] args) {
        Object arg = args[0];
        if (arg != null && arg instanceof HttpUriRequest) {
            return (HttpUriRequest)arg;
        }
        return null;
    }

    private NameIntValuePair<String> extractHost(URI uri) {
        if (uri == null) {
            return null;
        }
        NameIntValuePair target = null;
        if (uri.isAbsolute()) {
            int port = uri.getPort();
            String host = uri.getHost();
            if (host == null && (host = uri.getAuthority()) != null) {
                int colon;
                int at = host.indexOf(64);
                if (at >= 0) {
                    host = host.length() > at + 1 ? host.substring(at + 1) : null;
                }
                if (host != null && (colon = host.indexOf(58)) >= 0) {
                    int pos = colon + 1;
                    int len = 0;
                    for (int i = pos; i < host.length() && Character.isDigit(host.charAt(i)); ++i) {
                        ++len;
                    }
                    if (len > 0) {
                        try {
                            port = Integer.parseInt(host.substring(pos, pos + len));
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                    host = host.substring(0, colon);
                }
            }
            if (host != null) {
                target = new NameIntValuePair((Object)host, port);
            }
        }
        return target;
    }
}

