/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.kafka.KafkaConfig;
import com.navercorp.pinpoint.plugin.kafka.KafkaConstants;
import java.security.ProtectionDomain;
import java.util.List;

public class KafkaPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        KafkaConfig config = new KafkaConfig(context.getConfig());
        if (config.isProducerEnable()) {
            this.transformTemplate.transform("org.apache.kafka.clients.producer.KafkaProducer", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                    InstrumentMethod constructor = target.getConstructor(new String[]{"org.apache.kafka.clients.producer.ProducerConfig", "org.apache.kafka.common.serialization.Serializer", "org.apache.kafka.common.serialization.Serializer"});
                    if (constructor == null) {
                        constructor = target.getConstructor(new String[]{"org.apache.kafka.clients.producer.ProducerConfig", "org.apache.kafka.common.serialization.Serializer", "org.apache.kafka.common.serialization.Serializer", "org.apache.kafka.clients.Metadata", "org.apache.kafka.clients.KafkaClient"});
                    }
                    constructor.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ProducerConstructorInterceptor");
                    InstrumentMethod sendMethod = target.getDeclaredMethod("send", new String[]{"org.apache.kafka.clients.producer.ProducerRecord", "org.apache.kafka.clients.producer.Callback"});
                    sendMethod.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ProducerSendInterceptor");
                    target.addField(KafkaConstants.REMOTE_ADDRESS_ACCESSOR);
                    return target.toBytecode();
                }
            });
        }
        if (this.enableConsumerTransform(config)) {
            this.transformTemplate.transform("org.apache.kafka.clients.consumer.KafkaConsumer", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                    InstrumentMethod constructor = target.getConstructor(new String[]{"org.apache.kafka.clients.consumer.ConsumerConfig", "org.apache.kafka.common.serialization.Deserializer", "org.apache.kafka.common.serialization.Deserializer"});
                    constructor.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerConstructorInterceptor");
                    InstrumentMethod pollMethod = target.getDeclaredMethod("poll", new String[]{"long", "boolean"});
                    if (pollMethod == null) {
                        pollMethod = target.getDeclaredMethod("poll", new String[]{"long"});
                    }
                    pollMethod.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerPollInterceptor");
                    target.addField(KafkaConstants.REMOTE_ADDRESS_ACCESSOR);
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("org.apache.kafka.clients.consumer.ConsumerRecord", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                    target.addField(KafkaConstants.REMOTE_ADDRESS_ACCESSOR);
                    return target.toBytecode();
                }
            });
            if (config.isSpringConsumerEnable()) {
                this.transformTemplate.transform("org.springframework.kafka.listener.adapter.RecordMessagingMessageListenerAdapter", new TransformCallback(){

                    public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                        InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                        MethodFilter methodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"onMessage"}), MethodFilters.argAt((int)0, (String)"org.apache.kafka.clients.consumer.ConsumerRecord")});
                        List declaredMethods = target.getDeclaredMethods(methodFilter);
                        for (InstrumentMethod declaredMethod : declaredMethods) {
                            declaredMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerRecordEntryPointInterceptor", VarArgs.va((Object[])new Object[]{0}), "KAFKA_SCOPE", ExecutionPolicy.BOUNDARY);
                        }
                        return target.toBytecode();
                    }
                });
                this.transformTemplate.transform("org.springframework.kafka.listener.adapter.BatchMessagingMessageListenerAdapter", new TransformCallback(){

                    public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                        InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                        MethodFilter methodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"onMessage"}), MethodFilters.argAt((int)0, (String)"org.apache.kafka.clients.consumer.ConsumerRecords")});
                        List declaredMethods = target.getDeclaredMethods(methodFilter);
                        for (InstrumentMethod declaredMethod : declaredMethods) {
                            declaredMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerMultiRecordEntryPointInterceptor", VarArgs.va((Object[])new Object[]{0}), "KAFKA_SCOPE", ExecutionPolicy.BOUNDARY);
                        }
                        methodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"onMessage"}), MethodFilters.argAt((int)0, (String)"java.util.List")});
                        declaredMethods = target.getDeclaredMethods(methodFilter);
                        for (InstrumentMethod declaredMethod : declaredMethods) {
                            declaredMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerMultiRecordEntryPointInterceptor", VarArgs.va((Object[])new Object[]{0}), "KAFKA_SCOPE", ExecutionPolicy.BOUNDARY);
                        }
                        return target.toBytecode();
                    }
                });
            }
            if (StringUtils.hasText((String)config.getKafkaEntryPoint())) {
                this.transformEntryPoint(config.getKafkaEntryPoint());
            }
        }
    }

    private boolean enableConsumerTransform(KafkaConfig config) {
        if (config.isConsumerEnable() && StringUtils.hasText((String)config.getKafkaEntryPoint())) {
            return true;
        }
        return config.isSpringConsumerEnable();
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public void transformEntryPoint(String entryPoint) {
        String clazzName = this.toClassName(entryPoint);
        final String methodName = this.toMethodName(entryPoint);
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                block2: for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{methodName}))) {
                    try {
                        String[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes == null) continue;
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            String parameterType = parameterTypes[i];
                            if ("org.apache.kafka.clients.consumer.ConsumerRecord".equals(parameterType)) {
                                method.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerRecordEntryPointInterceptor", VarArgs.va((Object[])new Object[]{i}));
                                continue block2;
                            }
                            if (!"org.apache.kafka.clients.consumer.ConsumerRecords".equals(parameterType)) continue;
                            method.addInterceptor("com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerMultiRecordEntryPointInterceptor", VarArgs.va((Object[])new Object[]{i}));
                            continue block2;
                        }
                    }
                    catch (Exception e) {
                        if (!KafkaPlugin.this.logger.isWarnEnabled()) continue;
                        KafkaPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private String toClassName(String fullQualifiedMethodName) {
        int classEndPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (classEndPosition <= 0) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(0, classEndPosition);
    }

    private String toMethodName(String fullQualifiedMethodName) {
        int methodBeginPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (methodBeginPosition <= 0 || methodBeginPosition + 1 >= fullQualifiedMethodName.length()) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(methodBeginPosition + 1);
    }
}

