/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.plugin.ServerPluginLoader;
import com.navercorp.pinpoint.common.util.ClassLoaderUtils;
import com.navercorp.pinpoint.profiler.context.DefaultServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.util.RuntimeMXBeanUtils;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.test.ListenableDataSender;
import com.navercorp.pinpoint.test.MockPluginContextLoadResultProvider;
import com.navercorp.pinpoint.test.TestSpanStorageFactory;
import com.navercorp.pinpoint.test.TestTcpDataSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockApplicationContextModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void configure() {
        ListenableDataSender spanDataSender = new ListenableDataSender("SpanDataSender");
        this.logger.debug("spanDataSender:{}", spanDataSender);
        this.bind(DataSender.class).annotatedWith(SpanDataSender.class).toInstance(spanDataSender);
        ListenableDataSender statDataSender = new ListenableDataSender("StatDataSender");
        this.logger.debug("statDataSender:{}", statDataSender);
        this.bind(DataSender.class).annotatedWith(StatDataSender.class).toInstance(statDataSender);
        this.bind(TraceDataFormatVersion.class).toInstance((Object)TraceDataFormatVersion.V1);
        this.bind(StorageFactory.class).to(TestSpanStorageFactory.class);
        this.bind(PinpointClientFactory.class).toProvider(Providers.of((Object)null));
        TestTcpDataSender enhancedDataSender = new TestTcpDataSender();
        this.logger.debug("enhancedDataSender:{}", (Object)enhancedDataSender);
        TypeLiteral<EnhancedDataSender<Object>> dataSenderTypeLiteral = new TypeLiteral<EnhancedDataSender<Object>>(){};
        this.bind((TypeLiteral)dataSenderTypeLiteral).toInstance((Object)enhancedDataSender);
        ServerMetaDataRegistryService serverMetaDataRegistryService = this.newServerMetaDataRegistryService();
        this.bind(ServerMetaDataRegistryService.class).toInstance((Object)serverMetaDataRegistryService);
        this.bind(PluginLoader.class).toInstance((Object)new ServerPluginLoader(ClassLoaderUtils.getDefaultClassLoader()));
        this.bind(PluginContextLoadResult.class).toProvider(MockPluginContextLoadResultProvider.class).in(Scopes.SINGLETON);
    }

    private ServerMetaDataRegistryService newServerMetaDataRegistryService() {
        List vmArgs = RuntimeMXBeanUtils.getVmArgs();
        DefaultServerMetaDataRegistryService serverMetaDataRegistryService = new DefaultServerMetaDataRegistryService(vmArgs);
        return serverMetaDataRegistryService;
    }
}

