/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.provider.plugin.ProfilerPluginLoader;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjectorFactory;
import com.navercorp.pinpoint.profiler.plugin.DefaultPluginSetup;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.plugin.SetupResult;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginContextLoadResult
implements PluginContextLoadResult {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstrumentEngine instrumentEngine;
    private final ClassInjectorFactory classInjectorFactory;
    private final ProfilerConfig profilerConfig;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final List<SetupResult> setupResultList;

    public DefaultPluginContextLoadResult(ProfilerConfig profilerConfig, DynamicTransformTrigger dynamicTransformTrigger, InstrumentEngine instrumentEngine, PluginLoader pluginLoader, ClassInjectorFactory classInjectorFactory) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.dynamicTransformTrigger = (DynamicTransformTrigger)Assert.requireNonNull((Object)dynamicTransformTrigger, (String)"dynamicTransformTrigger must not be null");
        this.instrumentEngine = (InstrumentEngine)Assert.requireNonNull((Object)instrumentEngine, (String)"instrumentEngine must not be null");
        this.classInjectorFactory = (ClassInjectorFactory)Assert.requireNonNull((Object)classInjectorFactory, (String)"bootstrapCore must not be null");
        this.setupResultList = this.load(pluginLoader);
    }

    private List<SetupResult> load(PluginLoader pluginLoader) {
        Assert.requireNonNull((Object)pluginLoader, (String)"pluginLoader must not be null");
        this.logger.info("load plugin");
        DefaultPluginSetup pluginSetup = new DefaultPluginSetup(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger);
        ProfilerPluginLoader loader = new ProfilerPluginLoader(this.profilerConfig, pluginSetup, this.classInjectorFactory, pluginLoader);
        List<SetupResult> load = loader.load();
        return load;
    }

    @Override
    public List<ClassFileTransformer> getClassFileTransformer() {
        ArrayList<ClassFileTransformer> transformerList = new ArrayList<ClassFileTransformer>();
        for (SetupResult pluginContext : this.setupResultList) {
            List<ClassFileTransformer> classTransformerList = pluginContext.getClassTransformerList();
            transformerList.addAll(classTransformerList);
        }
        return transformerList;
    }

    @Override
    public List<ApplicationTypeDetector> getApplicationTypeDetectorList() {
        ArrayList<ApplicationTypeDetector> registeredDetectors = new ArrayList<ApplicationTypeDetector>();
        for (SetupResult context : this.setupResultList) {
            List<ApplicationTypeDetector> applicationTypeDetectors = context.getApplicationTypeDetectors();
            registeredDetectors.addAll(applicationTypeDetectors);
        }
        return registeredDetectors;
    }

    @Override
    public List<JdbcUrlParserV2> getJdbcUrlParserList() {
        ArrayList<JdbcUrlParserV2> result = new ArrayList<JdbcUrlParserV2>();
        for (SetupResult context : this.setupResultList) {
            List<JdbcUrlParserV2> jdbcUrlParserList = context.getJdbcUrlParserList();
            result.addAll(jdbcUrlParserList);
        }
        return result;
    }
}

