/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.compress.Context;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessor;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.module.ApplicationServerType;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.SpanThriftMessageConverter;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.thrift.TBase;

public class SpanThriftMessageConverterProvider
implements Provider<MessageConverter<TBase<?, ?>>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;
    private final ServiceType applicationServiceType;
    private final TransactionIdEncoder transactionIdEncoder;
    private final SpanPostProcessor<Context> spanPostProcessor;

    @Inject
    public SpanThriftMessageConverterProvider(@ApplicationName String applicationName, @AgentId String agentId, @AgentStartTime long agentStartTime, @ApplicationServerType ServiceType applicationServiceType, TransactionIdEncoder transactionIdEncoder, SpanPostProcessor<Context> spanPostProcessor) {
        this.applicationName = (String)Assert.requireNonNull((Object)applicationName, (String)"applicationName must not be null");
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTime = agentStartTime;
        this.applicationServiceType = (ServiceType)Assert.requireNonNull((Object)applicationServiceType, (String)"applicationServiceType must not be null");
        this.transactionIdEncoder = (TransactionIdEncoder)Assert.requireNonNull((Object)transactionIdEncoder, (String)"transactionIdEncoder must not be null");
        this.spanPostProcessor = (SpanPostProcessor)Assert.requireNonNull(spanPostProcessor, (String)"spanPostProcessor must not be null");
    }

    public MessageConverter<TBase<?, ?>> get() {
        return new SpanThriftMessageConverter(this.applicationName, this.agentId, this.agentStartTime, this.applicationServiceType.getCode(), this.transactionIdEncoder, this.spanPostProcessor);
    }
}

