/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.DefaultBaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.LoggingBaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanFactory;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTraceFactoryProvider
implements Provider<BaseTraceFactory> {
    private final TraceRootFactory traceRootFactory;
    private final StorageFactory storageFactory;
    private final TraceSampler traceSampler;
    private final Provider<AsyncContextFactory> asyncContextFactoryProvider;
    private final CallStackFactory<SpanEvent> callStackFactory;
    private final SpanFactory spanFactory;
    private final RecorderFactory recorderFactory;
    private final ActiveTraceRepository activeTraceRepository;

    @Inject
    public BaseTraceFactoryProvider(TraceRootFactory traceRootFactory, StorageFactory storageFactory, TraceSampler traceSampler, Provider<AsyncContextFactory> asyncContextFactoryProvider, CallStackFactory<SpanEvent> callStackFactory, SpanFactory spanFactory, RecorderFactory recorderFactory, ActiveTraceRepository activeTraceRepository) {
        this.traceRootFactory = (TraceRootFactory)Assert.requireNonNull((Object)traceRootFactory, (String)"traceRootFactory");
        this.callStackFactory = (CallStackFactory)Assert.requireNonNull(callStackFactory, (String)"callStackFactory");
        this.storageFactory = (StorageFactory)Assert.requireNonNull((Object)storageFactory, (String)"storageFactory");
        this.traceSampler = (TraceSampler)Assert.requireNonNull((Object)traceSampler, (String)"traceSampler");
        this.asyncContextFactoryProvider = (Provider)Assert.requireNonNull(asyncContextFactoryProvider, (String)"asyncContextFactory");
        this.spanFactory = (SpanFactory)Assert.requireNonNull((Object)spanFactory, (String)"spanFactory");
        this.recorderFactory = (RecorderFactory)Assert.requireNonNull((Object)recorderFactory, (String)"recorderFactory");
        this.activeTraceRepository = (ActiveTraceRepository)Assert.requireNonNull((Object)activeTraceRepository, (String)"activeTraceRepository");
    }

    public BaseTraceFactory get() {
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        BaseTraceFactory baseTraceFactory = new DefaultBaseTraceFactory(this.traceRootFactory, this.callStackFactory, this.storageFactory, this.traceSampler, asyncContextFactory, this.spanFactory, this.recorderFactory, this.activeTraceRepository);
        if (this.isDebugEnabled()) {
            baseTraceFactory = LoggingBaseTraceFactory.wrap(baseTraceFactory);
        }
        return baseTraceFactory;
    }

    private boolean isDebugEnabled() {
        Logger logger = LoggerFactory.getLogger(DefaultBaseTraceFactory.class);
        return logger.isDebugEnabled();
    }
}

