/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.DefaultAsyncContext;
import com.navercorp.pinpoint.profiler.context.StatefulAsyncContext;
import com.navercorp.pinpoint.profiler.context.id.AsyncIdGenerator;
import com.navercorp.pinpoint.profiler.context.id.DefaultAsyncTraceId;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.method.PredefinedMethodDescriptorRegistry;

public class DefaultAsyncContextFactory
implements AsyncContextFactory {
    private final AsyncTraceContext asyncTraceContext;
    private final AsyncIdGenerator asyncIdGenerator;
    private final PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry;
    private final int asyncMethodApiId;

    public DefaultAsyncContextFactory(AsyncTraceContext asyncTraceContext, AsyncIdGenerator asyncIdGenerator, PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry) {
        this.asyncTraceContext = (AsyncTraceContext)Assert.requireNonNull((Object)asyncTraceContext, (String)"traceFactoryProvider must not be null");
        this.asyncIdGenerator = (AsyncIdGenerator)Assert.requireNonNull((Object)asyncIdGenerator, (String)"asyncIdGenerator must not be null");
        this.predefinedMethodDescriptorRegistry = (PredefinedMethodDescriptorRegistry)Assert.requireNonNull((Object)predefinedMethodDescriptorRegistry, (String)"predefinedMethodDescriptorRegistry must not be null");
        this.asyncMethodApiId = this.getAsyncMethodApiId(predefinedMethodDescriptorRegistry);
    }

    private int getAsyncMethodApiId(PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry) {
        MethodDescriptor asyncMethodDescriptor = predefinedMethodDescriptorRegistry.getAsyncMethodDescriptor();
        return asyncMethodDescriptor.getApiId();
    }

    @Override
    public AsyncId newAsyncId() {
        return this.asyncIdGenerator.newAsyncId();
    }

    @Override
    public AsyncContext newAsyncContext(TraceRoot traceRoot, AsyncId asyncId) {
        Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        Assert.requireNonNull((Object)asyncId, (String)"asyncId must not be null");
        return new DefaultAsyncContext(this.asyncTraceContext, traceRoot, asyncId, this.asyncMethodApiId);
    }

    @Override
    public AsyncContext newAsyncContext(TraceRoot traceRoot, AsyncId asyncId, AsyncState asyncState) {
        Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        Assert.requireNonNull((Object)asyncId, (String)"asyncId must not be null");
        Assert.requireNonNull((Object)asyncState, (String)"asyncState must not be null");
        return new StatefulAsyncContext(this.asyncTraceContext, traceRoot, asyncId, this.asyncMethodApiId, asyncState);
    }

    @Override
    @Deprecated
    public AsyncTraceId newAsyncTraceId(TraceRoot traceRoot) {
        Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        AsyncId asyncId = this.asyncIdGenerator.newAsyncId();
        return new DefaultAsyncTraceId(traceRoot, asyncId);
    }
}

