/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncChildTrace
implements Trace {
    private static final int ASYNC_BEGIN_STACK_ID = 1001;
    private static final Logger logger = LoggerFactory.getLogger((String)AsyncChildTrace.class.getName());
    private static final boolean isWarn = logger.isWarnEnabled();
    private static final boolean isDebug = logger.isDebugEnabled();
    private final boolean sampling;
    private final CallStack<SpanEvent> callStack;
    private final Storage storage;
    private final TraceRoot traceRoot;
    private final WrappedSpanEventRecorder wrappedSpanEventRecorder;
    private final AsyncContextFactory asyncContextFactory;
    private final SpanRecorder spanRecorder;
    private boolean closed = false;
    private final DefaultTraceScopePool scopePool = new DefaultTraceScopePool();
    private final LocalAsyncId localAsyncId;

    public AsyncChildTrace(TraceRoot traceRoot, CallStack<SpanEvent> callStack, Storage storage, AsyncContextFactory asyncContextFactory, boolean sampling, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, LocalAsyncId localAsyncId) {
        this.traceRoot = (TraceRoot)Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        this.callStack = (CallStack)Assert.requireNonNull(callStack, (String)"callStack must not be null");
        this.storage = (Storage)Assert.requireNonNull((Object)storage, (String)"storage must not be null");
        this.asyncContextFactory = (AsyncContextFactory)Assert.requireNonNull((Object)asyncContextFactory, (String)"asyncContextFactory must not be null");
        this.sampling = sampling;
        this.spanRecorder = (SpanRecorder)Assert.requireNonNull((Object)spanRecorder, (String)"spanRecorder must not be null");
        this.wrappedSpanEventRecorder = (WrappedSpanEventRecorder)Assert.requireNonNull((Object)wrappedSpanEventRecorder, (String)"wrappedSpanEventRecorder must not be null");
        this.localAsyncId = (LocalAsyncId)Assert.requireNonNull((Object)localAsyncId, (String)"localAsyncId must not be null");
        this.traceBlockBegin(1001);
    }

    public long getId() {
        return this.traceRoot.getLocalTransactionId();
    }

    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    public Thread getBindThread() {
        return null;
    }

    public long getThreadId() {
        return -1L;
    }

    public TraceId getTraceId() {
        return this.traceRoot.getTraceId();
    }

    private SpanEventRecorder wrappedSpanEventRecorder(WrappedSpanEventRecorder wrappedSpanEventRecorder, SpanEvent spanEvent) {
        wrappedSpanEventRecorder.setWrapped(spanEvent);
        return wrappedSpanEventRecorder;
    }

    public boolean canSampled() {
        return this.sampling;
    }

    public boolean isRoot() {
        return this.traceRoot.getTraceId().isRoot();
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEvent traceBlockBegin0(int stackId) {
        if (this.closed) {
            if (isWarn) {
                this.stackDump("already closed trace");
            }
            SpanEvent dummy = this.dummySpanEvent();
            return dummy;
        }
        SpanEvent spanEvent = this.newSpanEvent(stackId);
        this.callStack.push(spanEvent);
        return spanEvent;
    }

    private void stackDump(String caused) {
        PinpointException exception = new PinpointException(caused);
        logger.warn("[DefaultTrace] Corrupted call stack found TraceRoot:{}, CallStack:{}", new Object[]{this.traceRoot, this.callStack, exception});
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        SpanEvent spanEvent = this.traceBlockBegin0(stackId);
        spanEvent.setLocalAsyncId(this.localAsyncId);
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    public void traceBlockEnd() {
        this.traceBlockEnd(-1);
    }

    public void traceBlockEnd(int stackId) {
        if (this.closed) {
            if (isWarn) {
                this.stackDump("already closed trace");
            }
            return;
        }
        SpanEvent spanEvent = this.callStack.pop();
        if (spanEvent == null) {
            if (isWarn) {
                this.stackDump("call stack is empty.");
            }
            return;
        }
        if (this.isDummySpanEvent(spanEvent)) {
            if (isDebug) {
                logger.debug("[AsyncChildTrace] Skip dummy spanEvent");
            }
            return;
        }
        if (spanEvent.getStackId() != stackId && isWarn) {
            this.stackDump("not matched stack id. expected=" + stackId + ", current=" + spanEvent.getStackId());
        }
        if (spanEvent.isTimeRecording()) {
            spanEvent.markAfterTime();
        }
        this.logSpan(spanEvent);
    }

    private void logSpan(SpanEvent spanEvent) {
        this.storage.store(spanEvent);
    }

    private void logSpan() {
        this.storage.flush();
    }

    public boolean isAsync() {
        return true;
    }

    public boolean isRootStack() {
        return this.getCallStackFrameId0() == 1001;
    }

    public int getCallStackFrameId0() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    @Deprecated
    public AsyncTraceId getAsyncTraceId() {
        return this.asyncContextFactory.newAsyncTraceId(this.traceRoot);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.traceBlockEnd(1001);
        this.close0();
    }

    public void close0() {
        if (this.closed) {
            logger.warn("Already closed childTrace");
            return;
        }
        this.closed = true;
        if (!this.callStack.empty()) {
            if (isWarn) {
                this.stackDump("not empty call stack");
            }
        } else {
            this.logSpan();
        }
        this.storage.close();
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            if (isWarn) {
                this.stackDump("call stack is empty");
            }
            spanEvent = this.dummySpanEvent();
        }
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent newSpanEvent(int stackId) {
        SpanEvent spanEvent = this.callStack.getFactory().newInstance();
        spanEvent.markStartTime();
        spanEvent.setStackId(stackId);
        return spanEvent;
    }

    @VisibleForTesting
    SpanEvent dummySpanEvent() {
        return this.callStack.getFactory().dummyInstance();
    }

    @VisibleForTesting
    boolean isDummySpanEvent(SpanEvent spanEvent) {
        return this.callStack.getFactory().isDummy(spanEvent);
    }

    public int getCallStackFrameId() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public TraceScope getScope(String name) {
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        return this.scopePool.add(name);
    }

    public String toString() {
        return "AsyncChildTrace{traceRoot=" + this.traceRoot + ", localAsyncId=" + this.localAsyncId + '}';
    }
}

