/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class JettyConfiguration {
    private final boolean enable;
    private final List<String> bootstrapMains;
    private final Filter<String> excludeUrlFilter;
    private final boolean hidePinpointHeader;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final boolean traceRequestParam;
    private final Filter<String> excludeProfileMethodFilter;

    public JettyConfiguration(ProfilerConfig config) {
        this.enable = config.readBoolean("profiler.jetty.enable", true);
        this.bootstrapMains = config.readList("profiler.jetty.bootstrap.main");
        String jettyExcludeURL = config.readString("profiler.jetty.excludeurl", "");
        this.excludeUrlFilter = !jettyExcludeURL.isEmpty() ? new ExcludePathFilter(jettyExcludeURL) : new SkipFilter();
        boolean hidePinpointHeader = config.readBoolean("profiler.jetty.hide-pinpoint-header", true);
        if (hidePinpointHeader) {
            hidePinpointHeader = config.readBoolean("profiler.jetty.hidepinpointheader", true);
        }
        this.hidePinpointHeader = hidePinpointHeader;
        String excludeProfileMethod = config.readString("profiler.jetty.excludemethod", "");
        this.excludeProfileMethodFilter = !excludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(excludeProfileMethod) : new SkipFilter();
        this.traceRequestParam = config.readBoolean("profiler.jetty.tracerequestparam", true);
        this.realIpHeader = config.readString("profiler.jetty.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.jetty.realipemptyvalue", null);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JettyConfiguration{");
        sb.append("enable=").append(this.enable);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append('}');
        return sb.toString();
    }
}

