/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.xpath;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.NodeAddData;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.xpath.ConfigurationNodePointerFactory;
import com.secnium.iast.thirdparty.org.apache.commons.jxpath.JXPathContext;
import com.secnium.iast.thirdparty.org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import com.secnium.iast.thirdparty.org.apache.commons.jxpath.ri.model.NodePointerFactory;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpressionEngine
implements ExpressionEngine {
    static final String PATH_DELIMITER = "/";
    static final String ATTR_DELIMITER = "@";
    private static final String NODE_PATH_DELIMITERS = "/@";
    private static final String SPACE = " ";

    @Override
    public List<ConfigurationNode> query(ConfigurationNode configurationNode, String string) {
        if (StringUtils.isEmpty(string)) {
            return Collections.singletonList(configurationNode);
        }
        JXPathContext jXPathContext = this.createContext(configurationNode, string);
        List<ConfigurationNode> list = jXPathContext.selectNodes(string);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public String nodeKey(ConfigurationNode configurationNode, String string) {
        if (string == null) {
            return "";
        }
        if (configurationNode.getName() == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + configurationNode.getName().length() + PATH_DELIMITER.length());
        if (string.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append(PATH_DELIMITER);
        }
        if (configurationNode.isAttribute()) {
            stringBuilder.append(ATTR_DELIMITER);
        }
        stringBuilder.append(configurationNode.getName());
        return stringBuilder.toString();
    }

    @Override
    public NodeAddData prepareAdd(ConfigurationNode configurationNode, String string) {
        List<ConfigurationNode> list;
        if (string == null) {
            throw new IllegalArgumentException("prepareAdd: key must not be null!");
        }
        String string2 = string;
        int n = XPathExpressionEngine.findKeySeparator(string2);
        if (n < 0) {
            string2 = this.generateKeyForAdd(configurationNode, string2);
            n = XPathExpressionEngine.findKeySeparator(string2);
        }
        if ((list = this.query(configurationNode, string2.substring(0, n).trim())).size() != 1) {
            throw new IllegalArgumentException("prepareAdd: key must select exactly one target node!");
        }
        NodeAddData nodeAddData = new NodeAddData();
        nodeAddData.setParent(list.get(0));
        this.initNodeAddData(nodeAddData, string2.substring(n).trim());
        return nodeAddData;
    }

    protected JXPathContext createContext(ConfigurationNode configurationNode, String string) {
        JXPathContext jXPathContext = JXPathContext.newContext((Object)configurationNode);
        jXPathContext.setLenient(true);
        return jXPathContext;
    }

    protected void initNodeAddData(NodeAddData nodeAddData, String string) {
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, NODE_PATH_DELIMITERS, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (PATH_DELIMITER.equals(string3)) {
                if (bl) {
                    this.invalidPath(string, " contains an attribute delimiter at an unallowed position.");
                }
                if (string2 == null) {
                    this.invalidPath(string, " contains a '/' at an unallowed position.");
                }
                nodeAddData.addPathNode(string2);
                string2 = null;
            } else if (ATTR_DELIMITER.equals(string3)) {
                if (bl) {
                    this.invalidPath(string, " contains multiple attribute delimiters.");
                }
                if (string2 == null && !bl2) {
                    this.invalidPath(string, " contains an attribute delimiter at an unallowed position.");
                }
                if (string2 != null) {
                    nodeAddData.addPathNode(string2);
                }
                bl = true;
                string2 = null;
            } else {
                string2 = string3;
            }
            bl2 = false;
        }
        if (string2 == null) {
            this.invalidPath(string, "contains no components.");
        }
        nodeAddData.setNewNodeName(string2);
        nodeAddData.setAttribute(bl);
    }

    private String generateKeyForAdd(ConfigurationNode configurationNode, String string) {
        int n = string.lastIndexOf(PATH_DELIMITER, string.length());
        while (n >= 0) {
            String string2 = string.substring(0, n);
            if (!this.query(configurationNode, string2).isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
                stringBuilder.append(string2).append(SPACE);
                stringBuilder.append(string.substring(n + 1));
                return stringBuilder.toString();
            }
            n = string.lastIndexOf(PATH_DELIMITER, n - 1);
        }
        return SPACE + string;
    }

    private void invalidPath(String string, String string2) {
        throw new IllegalArgumentException("Invalid node path: \"" + string + "\" " + string2);
    }

    private static int findKeySeparator(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && !Character.isWhitespace(string.charAt(n)); --n) {
        }
        return n;
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
    }
}

