/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

final class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            if (!OptionValidator.isValidOpt(c2)) {
                throw new IllegalArgumentException("Illegal option name '" + c2 + "'");
            }
        } else {
            for (char c3 : string.toCharArray()) {
                if (OptionValidator.isValidChar(c3)) continue;
                throw new IllegalArgumentException("The option '" + string + "' contains an illegal character : '" + c3 + "'");
            }
        }
    }

    private static boolean isValidOpt(char c2) {
        return OptionValidator.isValidChar(c2) || c2 == '?' || c2 == '@';
    }

    private static boolean isValidChar(char c2) {
        return Character.isJavaIdentifierPart(c2);
    }
}

