/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.CompositeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.JNDIConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SystemConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.XMLConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.XMLPropertiesConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.PropertyListConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.plist.XMLPropertyListConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.digester.AbstractObjectCreationFactory;
import com.secnium.iast.thirdparty.org.apache.commons.digester.CallMethodRule;
import com.secnium.iast.thirdparty.org.apache.commons.digester.Digester;
import com.secnium.iast.thirdparty.org.apache.commons.digester.ObjectCreationFactory;
import com.secnium.iast.thirdparty.org.apache.commons.digester.Rule;
import com.secnium.iast.thirdparty.org.apache.commons.digester.Substitutor;
import com.secnium.iast.thirdparty.org.apache.commons.digester.substitution.MultiVariableExpander;
import com.secnium.iast.thirdparty.org.apache.commons.digester.substitution.VariableExpander;
import com.secnium.iast.thirdparty.org.apache.commons.digester.substitution.VariableSubstitutor;
import com.secnium.iast.thirdparty.org.apache.commons.digester.xmlrules.DigesterLoader;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Deprecated
public class ConfigurationFactory {
    private static final String SEC_ROOT = "configuration/";
    private static final String SEC_OVERRIDE = "configuration/override/";
    private static final String SEC_ADDITIONAL = "configuration/additional/";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_FILENAME = "fileName";
    private static final String METH_LOAD = "load";
    private static final String DEF_BASE_PATH = ".";
    private static Log log = LogFactory.getLog(ConfigurationFactory.class);
    private String configurationFileName;
    private URL configurationURL;
    private String implicitBasePath;
    private String basePath;
    private URL digesterRules;
    private String digesterRuleNamespaceURI;

    public ConfigurationFactory() {
        this.setBasePath(DEF_BASE_PATH);
    }

    public ConfigurationFactory(String string) {
        this.setConfigurationFileName(string);
    }

    public Configuration getConfiguration() throws ConfigurationException {
        Digester digester;
        InputStream inputStream = null;
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        URL uRL = this.getConfigurationURL();
        try {
            if (uRL == null) {
                uRL = ConfigurationUtils.locate(this.implicitBasePath, this.getConfigurationFileName());
            }
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            log.error("Exception caught opening stream to URL", exception);
            throw new ConfigurationException("Exception caught opening stream to URL", exception);
        }
        if (this.getDigesterRules() == null) {
            digester = new Digester();
            this.configureNamespace(digester);
            this.initDefaultDigesterRules(digester);
        } else {
            digester = DigesterLoader.createDigester((URL)this.getDigesterRules());
            this.configureNamespace(digester);
        }
        digester.setUseContextClassLoader(true);
        this.enableDigesterSubstitutor(digester);
        digester.push((Object)configurationBuilder);
        try {
            digester.parse(inputStream);
            inputStream.close();
        }
        catch (SAXException sAXException) {
            log.error("SAX Exception caught", sAXException);
            throw new ConfigurationException("SAX Exception caught", sAXException);
        }
        catch (IOException iOException) {
            log.error("IO Exception caught", iOException);
            throw new ConfigurationException("IO Exception caught", iOException);
        }
        return configurationBuilder.getConfiguration();
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String string) {
        File file = new File(string).getAbsoluteFile();
        this.configurationFileName = file.getName();
        this.implicitBasePath = file.getParent();
    }

    public URL getConfigurationURL() {
        return this.configurationURL;
    }

    public void setConfigurationURL(URL uRL) {
        this.configurationURL = uRL;
        this.implicitBasePath = uRL.toString();
    }

    public URL getDigesterRules() {
        return this.digesterRules;
    }

    public void setDigesterRules(URL uRL) {
        this.digesterRules = uRL;
    }

    protected void enableDigesterSubstitutor(Digester digester) {
        Map map = System.getProperties();
        MultiVariableExpander multiVariableExpander = new MultiVariableExpander();
        multiVariableExpander.addSource("$", map);
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor((VariableExpander)multiVariableExpander);
        digester.setSubstitutor((Substitutor)variableSubstitutor);
    }

    protected void initDefaultDigesterRules(Digester digester) {
        this.initDigesterSectionRules(digester, SEC_ROOT, false);
        this.initDigesterSectionRules(digester, SEC_OVERRIDE, false);
        this.initDigesterSectionRules(digester, SEC_ADDITIONAL, true);
    }

    protected void initDigesterSectionRules(Digester digester, String string, boolean bl) {
        this.setupDigesterInstance(digester, string + "properties", (ObjectCreationFactory)new PropertiesConfigurationFactory(), METH_LOAD, bl);
        this.setupDigesterInstance(digester, string + "plist", (ObjectCreationFactory)new PropertyListConfigurationFactory(), METH_LOAD, bl);
        this.setupDigesterInstance(digester, string + "xml", (ObjectCreationFactory)new FileConfigurationFactory(XMLConfiguration.class), METH_LOAD, bl);
        this.setupDigesterInstance(digester, string + "hierarchicalXml", (ObjectCreationFactory)new FileConfigurationFactory(XMLConfiguration.class), METH_LOAD, bl);
        this.setupDigesterInstance(digester, string + "jndi", (ObjectCreationFactory)new JNDIConfigurationFactory(), null, bl);
        this.setupDigesterInstance(digester, string + "system", (ObjectCreationFactory)new SystemConfigurationFactory(), null, bl);
    }

    protected void setupDigesterInstance(Digester digester, String string, ObjectCreationFactory objectCreationFactory, String string2, boolean bl) {
        if (bl) {
            this.setupUnionRules(digester, string);
        }
        digester.addFactoryCreate(string, objectCreationFactory);
        digester.addSetProperties(string);
        if (string2 != null) {
            digester.addRule(string, (Rule)new CallOptionalMethodRule(string2));
        }
        digester.addSetNext(string, "addConfiguration", Configuration.class.getName());
    }

    protected void setupUnionRules(Digester digester, String string) {
        digester.addObjectCreate(string, AdditionalConfigurationData.class);
        digester.addSetProperties(string);
        digester.addSetNext(string, "addAdditionalConfig", AdditionalConfigurationData.class.getName());
    }

    public String getDigesterRuleNamespaceURI() {
        return this.digesterRuleNamespaceURI;
    }

    public void setDigesterRuleNamespaceURI(String string) {
        this.digesterRuleNamespaceURI = string;
    }

    private void configureNamespace(Digester digester) {
        if (this.getDigesterRuleNamespaceURI() != null) {
            digester.setNamespaceAware(true);
            digester.setRuleNamespaceURI(this.getDigesterRuleNamespaceURI());
        } else {
            digester.setNamespaceAware(false);
        }
        digester.setValidating(false);
    }

    public String getBasePath() {
        String string = StringUtils.isEmpty(this.basePath) || DEF_BASE_PATH.equals(this.basePath) ? this.implicitBasePath : this.basePath;
        return StringUtils.isEmpty(string) ? DEF_BASE_PATH : string;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    private static class CallOptionalMethodRule
    extends CallMethodRule {
        private boolean optional;

        public CallOptionalMethodRule(String string) {
            super(string);
        }

        public void begin(Attributes attributes) throws Exception {
            this.optional = attributes.getValue(ConfigurationFactory.ATTR_OPTIONAL) != null && PropertyConverter.toBoolean(attributes.getValue(ConfigurationFactory.ATTR_OPTIONAL)) != false;
            super.begin(attributes);
        }

        public void end() throws Exception {
            try {
                super.end();
            }
            catch (Exception exception) {
                if (this.optional) {
                    log.warn("Could not create optional configuration!", exception);
                }
                throw exception;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationBuilder {
        private CompositeConfiguration config = new CompositeConfiguration();
        private Collection<AdditionalConfigurationData> additionalConfigs = new LinkedList<AdditionalConfigurationData>();

        public void addConfiguration(Configuration configuration) {
            this.config.addConfiguration(configuration);
        }

        public void addAdditionalConfig(AdditionalConfigurationData additionalConfigurationData) {
            this.additionalConfigs.add(additionalConfigurationData);
        }

        public CompositeConfiguration getConfiguration() {
            if (!this.additionalConfigs.isEmpty()) {
                Configuration configuration = this.createAdditionalConfiguration(this.additionalConfigs);
                if (configuration != null) {
                    this.addConfiguration(configuration);
                }
                this.additionalConfigs.clear();
            }
            return this.config;
        }

        protected Configuration createAdditionalConfiguration(Collection<AdditionalConfigurationData> collection) {
            HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
            for (AdditionalConfigurationData additionalConfigurationData : collection) {
                hierarchicalConfiguration.addNodes(additionalConfigurationData.getAt(), this.createRootNode(additionalConfigurationData).getChildren());
            }
            return hierarchicalConfiguration.isEmpty() ? null : hierarchicalConfiguration;
        }

        private HierarchicalConfiguration.Node createRootNode(AdditionalConfigurationData additionalConfigurationData) {
            if (additionalConfigurationData.getConfiguration() instanceof HierarchicalConfiguration) {
                return ((HierarchicalConfiguration)additionalConfigurationData.getConfiguration()).getRoot();
            }
            HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
            ConfigurationUtils.copy(additionalConfigurationData.getConfiguration(), hierarchicalConfiguration);
            return hierarchicalConfiguration.getRoot();
        }
    }

    public static class AdditionalConfigurationData {
        private Configuration configuration;
        private String at;

        public String getAt() {
            return this.at;
        }

        public void setAt(String string) {
            this.at = string;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void addConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }
    }

    private class SystemConfigurationFactory
    extends DigesterConfigurationFactory {
        public SystemConfigurationFactory() {
            super(SystemConfiguration.class);
        }
    }

    private class JNDIConfigurationFactory
    extends DigesterConfigurationFactory {
        public JNDIConfigurationFactory() {
            super(JNDIConfiguration.class);
        }
    }

    public class PropertyListConfigurationFactory
    extends FileConfigurationFactory {
        public PropertyListConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String string = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (string != null && string.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertyListConfiguration();
            }
            return new PropertyListConfiguration();
        }
    }

    public class PropertiesConfigurationFactory
    extends FileConfigurationFactory {
        public PropertiesConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String string = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (string != null && string.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertiesConfiguration();
            }
            return new PropertiesConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileConfigurationFactory
    extends DigesterConfigurationFactory {
        public FileConfigurationFactory(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Object createObject(Attributes attributes) throws Exception {
            FileConfiguration fileConfiguration = this.createConfiguration(attributes);
            fileConfiguration.setBasePath(ConfigurationFactory.this.getBasePath());
            return fileConfiguration;
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            return (FileConfiguration)super.createObject(attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DigesterConfigurationFactory
    extends AbstractObjectCreationFactory {
        private Class<?> clazz;

        public DigesterConfigurationFactory(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Object createObject(Attributes attributes) throws Exception {
            return this.clazz.newInstance();
        }
    }
}

