/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc;

import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.grpc.GrpcClientPlugin;
import com.navercorp.pinpoint.plugin.grpc.GrpcConfig;
import com.navercorp.pinpoint.plugin.grpc.GrpcServerPlugin;

public class GrpcPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        GrpcConfig config = new GrpcConfig(context.getConfig());
        if (config.isClientEnable()) {
            this.addClientInterceptor();
        }
        if (config.isServerEnable()) {
            this.addServerInterceptor(config);
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private void addClientInterceptor() {
        GrpcClientPlugin grpcClientPlugin = new GrpcClientPlugin(this.transformTemplate);
        grpcClientPlugin.addInterceptor();
    }

    private void addServerInterceptor(GrpcConfig config) {
        GrpcServerPlugin grpcServerPlugin = new GrpcServerPlugin(this.transformTemplate, config);
        grpcServerPlugin.addInterceptor();
    }
}

