/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.Socket;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int EOF = -1;

    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOUtils.toByteArray(inputStream, 4096, true);
    }

    public static byte[] toByteArray(InputStream inputStream, boolean close) throws IOException {
        return IOUtils.toByteArray(inputStream, 4096, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream, int bufferSize, boolean close) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream must not be null");
        }
        if (bufferSize < 0) {
            throw new IllegalArgumentException("negative bufferSize");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[bufferSize];
            IOUtils.copy(inputStream, outputStream, buffer);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int readCount;
        while ((readCount = inputStream.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, readCount);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public static void closeQuietly(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            datagramSocket.close();
        }
    }
}

