/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutput;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutputStreamTransport;
import com.navercorp.pinpoint.thrift.io.ChunkHeaderBufferedTBaseSerializerFlushHandler;
import com.navercorp.pinpoint.thrift.io.HeaderUtils;
import com.navercorp.pinpoint.thrift.io.TBaseStream;
import com.navercorp.pinpoint.thrift.io.TReplaceListProtocol;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public class ChunkHeaderBufferedTBaseSerializer {
    private static final String FIELD_NAME_SPAN_EVENT_LIST = "spanEventList";
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private final TBaseStream eventStream;
    private final TypeLocator<TBase<?, ?>> locator;
    private final TProtocolFactory protocolFactory;
    private final ByteArrayOutputStreamTransport transport;
    private boolean writeChunkHeader = false;
    private int chunkSize = 16384;
    private ChunkHeaderBufferedTBaseSerializerFlushHandler flushHandler;

    public ChunkHeaderBufferedTBaseSerializer(ByteArrayOutputStream out, TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.transport = new ByteArrayOutputStreamTransport(out);
        this.eventStream = new TBaseStream(protocolFactory);
        this.protocolFactory = protocolFactory;
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TBase<?, ?> base) throws TException {
        ByteArrayOutputStreamTransport byteArrayOutputStreamTransport = this.transport;
        synchronized (byteArrayOutputStreamTransport) {
            if (base instanceof TSpan) {
                this.addTSpan(base);
            } else if (base instanceof TSpanChunk) {
                this.addTSpanChunk(base);
            } else {
                this.write(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTSpanChunk(TBase<?, ?> base) throws TException {
        TSpanChunk chunk = (TSpanChunk)base;
        if (chunk.getSpanEventList() == null) {
            this.write(base);
            return;
        }
        try {
            for (TSpanEvent e : chunk.getSpanEventList()) {
                this.eventStream.write(e);
            }
            this.write(chunk, FIELD_NAME_SPAN_EVENT_LIST, this.eventStream.split(this.chunkSize));
            while (!this.eventStream.isEmpty()) {
                this.write(chunk, FIELD_NAME_SPAN_EVENT_LIST, this.eventStream.split(this.chunkSize));
            }
        }
        finally {
            this.eventStream.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTSpan(TBase<?, ?> base) throws TException {
        TSpan span = (TSpan)base;
        if (span.getSpanEventList() == null) {
            this.write(base);
            return;
        }
        try {
            for (TSpanEvent e : span.getSpanEventList()) {
                this.eventStream.write(e);
            }
            this.write(span, FIELD_NAME_SPAN_EVENT_LIST, this.eventStream.split(this.chunkSize));
            while (!this.eventStream.isEmpty()) {
                TSpanChunk spanChunk = this.toSpanChunk(span);
                this.write(spanChunk, FIELD_NAME_SPAN_EVENT_LIST, this.eventStream.split(this.chunkSize));
            }
        }
        finally {
            this.eventStream.clear();
        }
    }

    private void write(TBase<?, ?> base, String fieldName, List<ByteArrayOutput> list) throws TException {
        TReplaceListProtocol protocol = new TReplaceListProtocol(this.protocolFactory.getProtocol((TTransport)this.transport));
        this.writeChunkHeader(protocol);
        Header header = this.locator.headerLookup(base);
        if (header == null) {
            throw new TException("header must not be null base:" + base);
        }
        HeaderUtils.writeHeader(protocol, header);
        if (CollectionUtils.hasLength(list)) {
            protocol.addReplaceField(fieldName, list);
        }
        base.write((TProtocol)protocol);
        if (this.isNeedFlush()) {
            this.flush();
        }
    }

    private void write(TBase<?, ?> base) throws TException {
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)this.transport);
        this.writeChunkHeader(protocol);
        Header header = this.locator.headerLookup(base);
        if (header == null) {
            throw new TException("header must not be null base:" + base);
        }
        HeaderUtils.writeHeader(protocol, header);
        base.write(protocol);
        if (this.isNeedFlush()) {
            this.flush();
        }
    }

    private boolean isNeedFlush() {
        return this.flushHandler != null && this.transport.getBufferPosition() > this.chunkSize;
    }

    private void writeChunkHeader(TProtocol protocol) throws TException {
        if (this.writeChunkHeader) {
            return;
        }
        HeaderUtils.writeHeader(protocol, this.locator.headerLookup((short)400));
        this.writeChunkHeader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws TException {
        ByteArrayOutputStreamTransport byteArrayOutputStreamTransport = this.transport;
        synchronized (byteArrayOutputStreamTransport) {
            if (this.flushHandler != null && this.transport.getBufferPosition() > 4) {
                this.flushHandler.handle(this.transport.getBuffer(), 0, this.transport.getBufferPosition());
            }
            this.transport.flush();
            this.writeChunkHeader = false;
        }
    }

    public ChunkHeaderBufferedTBaseSerializerFlushHandler getFlushHandler() {
        return this.flushHandler;
    }

    public void setFlushHandler(ChunkHeaderBufferedTBaseSerializerFlushHandler flushHandler) {
        this.flushHandler = flushHandler;
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("transport=").append((Object)this.transport).append(", ");
        sb.append("chunkSize=").append(this.chunkSize);
        sb.append("}");
        return sb.toString();
    }

    TSpanChunk toSpanChunk(TSpan span) {
        TSpanChunk spanChunk = new TSpanChunk();
        spanChunk.setSpanEventList(span.getSpanEventList());
        spanChunk.setSpanEventListIsSet(true);
        spanChunk.setAgentId(span.getAgentId());
        spanChunk.setAgentIdIsSet(true);
        spanChunk.setApplicationName(span.getApplicationName());
        spanChunk.setApplicationNameIsSet(true);
        spanChunk.setAgentStartTime(span.getStartTime());
        spanChunk.setAgentStartTimeIsSet(true);
        spanChunk.setTransactionId(span.getTransactionId());
        spanChunk.setTransactionIdIsSet(true);
        spanChunk.setSpanId(span.getSpanId());
        spanChunk.setSpanIdIsSet(true);
        spanChunk.setEndPoint(span.getEndPoint());
        spanChunk.setEndPointIsSet(true);
        return spanChunk;
    }
}

